$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovaCondicao",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de uma condição de pagamento.",
          position: "right",
        },
      },
      {
        element: "#tabelaCondicaoPagamento",
        popover: {
          title: "Tabela Condição de Pagamento",
          description: "Aqui estão os dados das condições de pagamento cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  function retornaBotaoOpcoes() {
    return (
      '<div class="divBtnOpcoes"> ' +
      '    <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-edit" style="color:green"></span></button>      ' +
      '    <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      "   </div>"
    );
  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  async function ConsultaCondicaoPagamento(bBotao = false) {
    try {
      let response;
      $.LoadingOverlay("show");
      let condicaopagamento =
        pegaChave("#txtCondPagtoConsulta") != ""
          ? ` AND CODCOND = '${pegaChave("#txtCondPagtoConsulta")}'`
          : "";
      if (bBotao) {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          `JSON={ "tabela":"condicao", "camposSelect":[ "CodCond", "descricao"], "where":  ["1=1 ${condicaopagamento}"]}`,
          null
        );
      } else {
        response = await requisicao("GET", "/Sisplan/Funcoes/V1/pesquisa?", 'JSON={ "tabela":"condicao", "camposSelect":[ "CodCond", "descricao"], "where": null}', null);
      }

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      if (colunasInvisiveis == null || colunasInvisiveis.acessoCadCondPagamento == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadCondPagamento: ['EMPRESA'] }));
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      }

      $("#tabelaCondicaoPagamento").DataTable({
        destroy: true,
        lengthChange: true,
        searching: true,
        paging: true,
        scrollX: true,
        scrollY: '350px',
        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "CODCOND",
            title: "Código"
          },
          {
            data: "DESCRICAO",
            title: "Descrição"
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $('#tabelaCondicaoPagamento_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaCondicaoPagamento_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const dados = $("#tabelaCondicaoPagamento").DataTable().data().toArray();
        await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso cadastro de Condição de Pagamento', '', '', 999, false, false, dados);
      });

      $('#tabelaCondicaoPagamento').DataTable().columns().every(function () {
        if ((colunasInvisiveis.acessoCadCondPagamento).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaCondicaoPagamento').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    adicionaColunas(cols, colunasInvisiveis.acessoCadCondPagamento ?? ['EMPRESA']);
  });

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      removeColunasFixas(novasColunas, ["CODCOND"]);
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadCondPagamento: novasColunas }));

      $('#tabelaCondicaoPagamento').DataTable().columns().visible(true);

      $('#tabelaCondicaoPagamento').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtCondPagtoConsulta").val("");
  });

  $("#btn-limpa-codigo").on("click", async function () {
    $("#txtCondPagtoConsulta").val("");
  });

  $("#btnConsultar").on("click", async function () {
    $("#modal-filtros").modal("hide");
    await ConsultaCondicaoPagamento(true);
  });

  $(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("CONDICAOPAGAMENTO");

    $('#btnFiltros').on('click', async function () {
      $('#modal-filtros').modal('show');
    })

    $('#btnNovaCondicao').on('click', async function () {
      if (permissaoUsuarioLogado.INCLUI == 'S') {
        window.location.href = "condicaopagamento/create";
      } else {
        msgAlertaSemConfirmacao("Sem permissão para incluir!");
      }
    })

    $("#txtCondPagtoConsulta").autocompleta(
      1,
      `JSON={ "tabela":"CONDICAO", "camposSelect":[ "CODCOND CHAVE", "DESCRICAO DESCRICAO"], "where": null}`
    );

    $("#btn-condPagto").pesquisa(
      "#txtCondPagtoConsulta",
      "CODCOND",
      "DESCRICAO",
      `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONDICAO", "camposSelect":[ "CODCOND", "DESCRICAO"]}`,
      "Pesquisa Condicao pagamento",
      "condicao"
    );

    $("#btn-limpa-codigo").on("click", function () {
      $("#txtCondPagtoConsulta").val("");
    });

    ConsultaCondicaoPagamento();

    $("#tabelaCondicaoPagamento").on("click", "#btn-editar", async function () {
      if (permissaoUsuarioLogado.ALTERA == 'S') {
        let data = $("#tabelaCondicaoPagamento").DataTable().row($(this).parents("tr")).data();
        let registroLiberado = await verificarRegistro("CONDICAOPAGAMENTO", data.CODCOND);
        if (registroLiberado) {
          window.location.href = `condicaopagamento/${data.CODCOND}`;
        }
      } else {
        msgAlertaSemConfirmacao("Sem permissão para alterar!");
      }
    });

    $("#tabelaCondicaoPagamento").on("dblclick", "tr", async function () {
      if (permissaoUsuarioLogado.ALTERA == 'S') {
        let data = $("#tabelaCondicaoPagamento").DataTable().row($(this)).data();
        let registroLiberado = await verificarRegistro("CONDICAOPAGAMENTO", data.CODCOND);
        if (registroLiberado) {
          window.location.href = `condicaopagamento/${data.CODCOND}`;
        }
      } else {
        msgAlertaSemConfirmacao("Sem permissão para alterar!");
      }
    });

    $('#tabelaCondicaoPagamento').on('click', '#btn-excluir', async function () {
      if (permissaoUsuarioLogado.EXCLUI == 'S') {
        msgAlerta('Você realmente deseja excluir esse registro?', async () => {
          const data = $("#tabelaCondicaoPagamento").DataTable().row($(this).parents("tr"));
          await excluiRegistro(data);
        });
      } else {
        msgAlertaSemConfirmacao("Sem permissão para excluir!");
      }
    });

    async function excluiRegistro(data) {
      try {
        $.LoadingOverlay("show");
        try {
          let valorLinha = data.data();
          let response = await requisicao("DELETE",
            "/Sisplan/Cadastros/v1/condicaopagamento?",
            `CODCOND=${encodeURIComponent(valorLinha.CODCOND)}`,
            null);
          if (!response) {
            return;
          }
          if (response.status != 200) {
            let jsonStr = await response.json();
            msgErro(jsonStr.mensagem);
            return;
          }

          toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
            toastClass: "success",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              data.remove().draw(false);
            },
          }).css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });

        } catch (error) {
          console.error(error);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }
  });
});