<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sisplan Web | Cor</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.256.23.1">
    <!-- Theme style -->
    <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.256.23.1">

    <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="dist/css/custom.css?versao=3.256.23.1">
    <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.256.23.1">
    <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.256.23.1">
    <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.256.23.1" />
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.256.23.1" />
    <link rel="stylesheet" href="dist/css/select.bootstrap.min.css?versao=3.256.23.1" />
    <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.256.23.1">
    <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.256.23.1">
    <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.256.23.1">
    <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.256.23.1">
    <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.256.23.1">
    <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.256.23.1">

    <style>
        #tabelaCor td div button {
            padding: .0rem .5rem;
            margin-top: .1rem;
            margin-bottom: .2rem;
        }

        #tabelaCor td {
            padding: 0 !important;
            padding-left: 10px !important;
        }

        .border-Field .textoBorda {
            font-size: 1.1em !important;
            text-align: left !important;
            width: auto;
            padding: 0 10px;
            border-bottom: none;
        }

        .border-Field {
            border: 1px solid var(--font-color) !important;
            border-radius: 3px !important;
            padding: 0 1.0em 0 1.0em !important;
            margin: 0 0 0 0 !important;
            -webkit-box-shadow: 0px 0px 0px 0px #000;
            box-shadow: 0px 0px 0px 0px #000;
        }
    </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">
        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6 flex">
                            <h1 class="m-0 text-dark">Cor</h1>
                            <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                                <i class="fas fa-question-circle"></i></button>
                        </div>
                        <div class="col-sm-6">

                        </div><!-- /.col -->
                    </div><!-- /.row -->
                </div>
                <div class="container-fluid" id="tabelaCorForne">
                    <div class="row card">
                        <div class="col-sm-12 mt-3">
                            <button class="btn btn-success btn-sisp" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
                            <button class="btn btn-danger btn-sisp" id="btnNovaCor"><span class="fas fa-plus"></span> Incluir</button>
                            <button id="btnAlterarDadosEmMassa" data-target="modalAlterarDadosEmMassa" class="btn-sisp btn btn-secondary" title="Clique para alterar dados em massa dos produtos selecionados."><i class="fas fa-sync"></i> Alterar Selecionados</button>
                            <button id="btnUtilizacao" data-target="modalUtilizacao" class="btn-sisp btn btn-secondary"><i class="fas fa-clipboard-list"></i> Produto/Material</button>
                        </div>
                        <div class="col-sm-12 table-responsive card-body">
                            <h5>Lista de Cores</h5>
                            <table id="tabelaCor" class="table table-sm table-select table-hover" width="100%">
                                <thead>
                                    <tr>
                                        <th class="th-sm" style="max-width: 20px">
                                            <div class="icheck-primary d-inline">
                                                <input type="checkbox" id="cbSelAll">
                                                <label for="cbSelAll"></label>
                                            </div>
                                        </th>
                                        <th class="th-sm">Cor
                                        </th>
                                        <th class="th-sm">Descrição
                                        </th>
                                        <th class="th-sm">Código 2
                                        </th>
                                        <th class="th-sm text-center">RGB
                                        </th>
                                        <th class="th-sm text-center">Foto
                                        </th>
                                        <th class="th-sm">Inativo
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content" id="modalBody">
                            <div class="modal-header">
                                <h4 class="modal-title">Filtros</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <div class="row justify-content-sm-start justify-content-center mb-3">
                                    <div class="col-auto">
                                        <fieldset class="form border-Field mb-0 pb-0 d-sm-flex d-block">
                                            <div class="m-1 icheck-primary">
                                                <input type="radio" id="cbTodos" name="cbStatusCor" value="" checked>
                                                <label for="cbTodos">Todos</label>
                                            </div>
                                            <div class="m-1 icheck-primary">
                                                <input type="radio" id="cbAtivo" name="cbStatusCor" value="S">
                                                <label for="cbAtivo">Ativo</label>
                                            </div>
                                            <div class="m-1 icheck-primary">
                                                <input type="radio" id="cbInativo" name="cbStatusCor" value="N">
                                                <label for="cbInativo">Inativo</label>
                                            </div>
                                        </fieldset>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-6" id="CorInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtCorConsulta">Cor </label>
                                        <div class="input-group">
                                            <input type="text" autocomplete="off" class="input-default focus form-control" id="txtCorConsulta" name="txtCorConsulta" class="form-control" placeholder="Cor">
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btn-Cor" name="btn-Cor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btn-limpa-Cor" name="btn-limpa-Cor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-6" id="GrupoCorInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtGrupoCorConsulta">Grupo Cor </label>
                                        <div class="input-group">
                                            <input type="text" autocomplete="off" class="input-default focus form-control" id="txtGrupoCorConsulta" name="txtGrupoCorConsulta" class="form-control" placeholder="Grupo Cor">
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btn-GrupoCor" name="btn-GrupoCor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btn-limpa-GrupoCor" name="btn-limpa-GrupoCor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-6" id="GrupoCorInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtSubGrupoCorConsulta">Sub Grupo Cor </label>
                                        <div class="input-group">
                                            <input type="text" autocomplete="off" class="input-default focus form-control" id="txtSubGrupoCorConsulta" name="txtSubGrupoCorConsulta" class="form-control" placeholder="Sub Grupo Cor">
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btn-SubGrupoCor" name="btn-SubGrupoCor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btn-limpa-SubGrupoCor" name="btn-limpa-SubGrupoCor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-6" id="GrupoCorInfoTour">
                                        <label data-error="wrong" data-success="right" for="txtClasseComercialConsulta">Classe Comercial </label>
                                        <div class="input-group">
                                            <input type="text" autocomplete="off" class="input-default focus form-control" id="txtClasseComercialConsulta" name="txtClasseComercialConsulta" class="form-control" placeholder="Classe Comercial">
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btn-ClasseComercial" name="btn-ClasseComercial" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btn-limpa-ClasseComercial" name="btn-limpa-ClasseComercial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-lg-6 col-xl-6 form-group text-left">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtCliente">Cliente:</label>
                                        <div class="input-group">
                                            <input type="text" class="input-default focus form-control" aria-describedby="clienteError" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button">
                                                    <i class="m-0 p-0 fas fa-search"></i>
                                                </button>
                                                <button class="btn bg-danger" id="btnLimpaCliente" type="button">
                                                    <i class="m-0 p-0 fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <div class="row">
                                    <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
                                    <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal fade" data-backdrop="static" id="modalAlterarDadosEmMassa" tabindex="-1" role="dialog" aria-labelledby="modalAlterarDadosEmMassa" aria-hidden="true">
                    <div class="modal-dialog" style="min-width: 80%; min-height: 100%">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title">Alterar Dados Em Massa</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body pb-0">
                                <div class="form-row">

                                    <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtGrupoAlterarDados">Grupo:</label>
                                        <div class="input-group">
                                            <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtGrupoAlterarDados" name="txtGrupoAlterarDados" placeholder="Grupo">
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnGrupoAlterarDados" name="btnGrupoAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnLimpaGrupoAlterarDados" name="btnLimpaGrupoAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtSubGrupoAlterarDados">Sub. Grupo:</label>
                                        <div class="input-group">
                                            <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtSubGrupoAlterarDados" name="txtSubGrupoAlterarDados" placeholder="Grupo">
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnSubGrupoAlterarDados" name="btnSubGrupoAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnLimpaSubGrupoAlterarDados" name="btnLimpaSubGrupoAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtClasseComercialAlterarDados">Classe Comercial:</label>
                                        <div class="input-group">
                                            <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtClasseComercialAlterarDados" name="txtClasseComercialAlterarDados" placeholder="Grupo">
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnClasseComercialAlterarDados" name="btnClasseComercialAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnLimpaClasseComercialAlterarDados" name="btnLimpaClasseComercialAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-4 col-md-6 col-12 form-group">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtClienteAlterarDados">Cliente:</label>
                                        <div class="input-group">
                                            <input type="text" class="input-default focus form-control campoAlterarDadosEmMassa" id="txtClienteAlterarDados" name="txtClienteAlterarDados" placeholder="Cliente">
                                            <div class="input-group-append">
                                                <button class="btn bg-danger" id="btnClienteAlterarDados" name="btnClienteAlterarDados" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                <button class="btn bg-danger" id="btnLimpaClienteAlterarDados" name="btnLimpaClienteAlterarDados" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer px-0">
                                    <button type="submit" class="btn btn-primary btn-sisp" id="btnConfirmarAlterarDados">Confirmar</button>
                                    <button class="btn btn-danger btn-sisp" id="btnLimparCamposAlterarDados"><span class="fas fa-trash"></span>Limpar Campos</button>
                                    <button class="btn btn-danger btn-sisp" class="close" data-dismiss="modal" aria-label="Close" id="btnCancelarAlterarDados">Cancelar</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="modal fade" data-backdrop="static" id="modalUtilizacao" tabindex="-1" role="dialog" aria-labelledby="modalUtilizacao" aria-hidden="true">
                    <div class="modal-dialog modal-xl">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title">Consulta Produto/Material por Cor</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body pb-0">
                                <div class="row justify-content-sm-start justify-content-center mb-3">
                                    <div class="col-auto">
                                        <fieldset class="form border-Field mb-0 pb-0 d-sm-flex d-block">
                                            <legend class="textoBorda mb-0 pb-0">Status Cor</legend>
                                            <div class="m-1 icheck-primary">
                                                <input type="radio" id="cbTodosUtilizacao" name="cbStatusCorUtilizacao" class="cbStatusCorUtilizacao" value="" checked>
                                                <label for="cbTodosUtilizacao">Todos</label>
                                            </div>
                                            <div class="m-1 icheck-primary">
                                                <input type="radio" id="cbAtivoUtilizacao" name="cbStatusCorUtilizacao" class="cbStatusCorUtilizacao" value="S">
                                                <label for="cbAtivoUtilizacao">Ativo</label>
                                            </div>
                                            <div class="m-1 icheck-primary">
                                                <input type="radio" id="cbInativoUtilizacao" name="cbStatusCorUtilizacao" class="cbStatusCorUtilizacao" value="N">
                                                <label for="cbInativoUtilizacao">Inativo</label>
                                            </div>
                                        </fieldset>
                                    </div>
                                </div>
                                <div class="d-flex flex-column">
                                    <div class="d-flex">
                                        <div style="width: 100%;" id="ProdutoInfoTour">
                                            <label data-error="wrong" data-success="right" for="txtProdutoUtilizacao">Produto: </label>
                                            <div class="relative">
                                                <div class="input-group">
                                                    <select class="js-example-programmatic js-states form-control" id="txtProdutoUtilizacao" name="txtProdutoUtilizacao" multiple="multiple">
                                                    </select>
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnProdutoUtilizacao" name="btnProdutoUtilizacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btnLimpaProdutoUtilizacao" name="btnLimpaProdutoUtilizacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-end ml-1">
                                            <button id="btnIncluirCorProduto" type="button" style="height: 40px;" class="btn btn-danger btn-sisp">
                                                Incluir
                                            </button>
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="flex flex-column col-12 my-2">
                                            <div class="bordaTabelasUtilizacao">
                                                <h5 class="mb-0">Produtos</h5>
                                                <div class="table-responsive">
                                                    <table id="tabelaProdutosUtilizacao" class="table table-select table-hover" width="100%">
                                                        <thead>
                                                        </thead>
                                                        <tbody>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex flex-column">
                                    <div class="d-flex">

                                        <div style="width: 100%;" id="MaterialInfoTour">
                                            <label data-error="wrong" data-success="right" for="txtMaterialUtilizacao">Material: </label>
                                            <div class="relative">
                                                <div class="input-group">
                                                    <select class="js-example-programmatic js-states form-control" id="txtMaterialUtilizacao" name="txtMaterialUtilizacao" multiple="multiple">
                                                    </select>
                                                    <div class="input-group-append">
                                                        <button class="btn bg-danger" id="btnMaterialUtilizacao" name="btnMaterialUtilizacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                                        <button class="btn bg-danger" id="btnLimpaMaterialUtilizacao" name="btnLimpaMaterialUtilizacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-end ml-1">
                                            <button id="btnIncluirCorMaterial" type="button" style="height: 40px;" class="btn btn-danger btn-sisp">
                                                Incluir
                                            </button>
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="flex flex-column col-12 my-2">
                                            <div class="bordaTabelasUtilizacao">
                                                <h5 class="mb-0">Materiais</h5>
                                                <div class="table-responsive">
                                                    <table id="tabelaMateriaisUtilizacao" class="table table-select table-hover" width="100%">
                                                        <thead>
                                                        </thead>
                                                        <tbody>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                            </div>
                            <div class="modal-footer">
                                <button class="btn btn-danger btn-sisp" class="close" data-dismiss="modal" aria-label="Close" id="btnFecharUtilizacao">Fechar</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
    include_once('../../../modais.php');
    ?>
    <aside class="control-sidebar control-sidebar-dark">
    </aside>
    </div>
    <script src="plugins/jquery/jquery.min.js?versao=3.256.23.1"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.256.23.1"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.256.23.1"></script>
    <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.256.23.1"></script>
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.256.23.1"></script>
    <script src="dist/js/adminlte.min.js?versao=3.256.23.1"></script>
    <script src="dist/js/sisplan.js?versao=3.256.23.1"></script>
    <script src="utils/funcoes.js?versao=3.256.23.1"></script>
    <script src="utils/cookies.js?versao=3.256.23.1"></script>
    <script src="dist/js/requisicoes.js?versao=3.256.23.1"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=3.256.23.1"></script>
    <script src="dist/js/driver.min.js?versao=3.256.23.1"></script>
    <script src="plugins/toastr/toastr.min.js?versao=3.256.23.1"></script>

    <script type="text/javascript" src="dist/js/sum().js?versao=3.256.23.1"></script>
    <script type="text/javascript" src="config.js?versao=3.256.23.1"></script>
    <script>
        $(document).ready(async function() {
            if (getCookie('usuario') == "") {
                window.location.href = `${BASE_URI}/login`;
                return;
            }

            let usuario = getCookie('usuario');
            let empresa = getCookie('empresa');

            ipInterno = IP_INTERNO;
            ipExterno = IP_EXTERNO;
            basicAuth = BASIC_AUTH;

            const temAcesso = await temAcessoTela('COR');
            if (!temAcesso.resultado) {
                toastrAcesso(temAcesso, BASE_URI);
                return;
            }

            sArquivo = `${BASE_URI}/pages/cor/acesso_cor/acesso_cor.js?versao=3.256.23.1`;
            insereJavaScriptPagina(sArquivo);

        });
    </script>
</body>

</html>