$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btnFiltros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os filtros padrões da tela.',
                position: 'right'
            }
        },
        {
            element: '#btnNovoMaterial',
            popover: {
                title: 'Botão Incluir',
                description: 'Clique aqui para iniciar o cadastro de um material.',
                position: 'right'
            }
        },
        {
            element: '#tabelaCadMaterial_wrapper',
            popover: {
                title: 'Tabela Produtos',
                description: 'Aqui estão os dados dos materiais cadastrados.',
                position: 'top'
            }
        }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("MATERIAL");

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnNovoMaterial').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "material/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    componenteFiltro('material', true)
    componenteFiltro('grupo', true)
    componenteFiltro('subGrupo', true)
    componenteFiltro('linha', true)
    componenteFiltro('ncm', true)
    componenteFiltro('cliente', true, true, 'ClienteFornecedor')
    componenteFiltro('composicaoMaterial', true, true, 'Composicao')
    componenteFiltro('status', true)
    componenteFiltro('cstIcms', true, true, 'IcmsSaida')
    componenteFiltro('cstIcms', true, true, 'IcmsEntrada')
    componenteFiltro('cstIpi', true, true, 'IpiSaida')
    componenteFiltro('cstIpi', true, true, 'IpiEntrada')
    componenteFiltro('cor', true)
    componenteFiltro('faixaMaterial', true, true, 'Faixa')

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '    <button class="dropdown-item" type="button" title="Duplicar" id="btn-duplicar">Duplicar</button>     ' +
            `    <button class="dropdown-item" type="button" title="${getCookie('cod_usuario') == '0000' ? 'Este botão chama o Layout RelMaterialIndividual.FR3' : 'Imprimir'}" id="btnImprimir">Imprimir</button>     ` +
            '    <button class="dropdown-item" type="button" title="Anexos" id="btnAnexos">Gestão Documentos</button>     ' +
            '    <button class="dropdown-item" type="button" title="Itens em Estoque de Materiais" id="btnMatItensEst">Estoque de Materiais</button>     ' +
            '</div>';
        return retorno;
    };

    setTimeout(() => retornarFiltros().then(
        (filtros) => filtros && retornarDados(filtros)
    ), 0)

    $('#btnConsultar').on('click', async function () {
        retornarFiltros().then(
            (filtros) => filtros && retornarDados(filtros)
        )
    })

    $('#btnLimparFiltros').on('click', function () {
        $('input[name="cbStatus"]')?.filter('#cbTodos')?.prop('checked', true)
        $('#txtCadastroDe').val('1200-01-01')
        $('#txtCadastroAte').val('2500-12-31')
        $('#txtAlteracaoDe').val('1200-01-01')
        $('#txtAlteracaoAte').val('2500-12-31')
        $('#txtMaterial').empty().trigger('change')
        $('#txtGrupo').empty().trigger('change')
        $('#txtLinha').empty().trigger('change')
        $('#txtSubGrupo').empty().trigger('change')
        $('#txtNcm').empty().trigger('change')
        $('#txtClienteFornecedor').empty().trigger('change')
        $('#txtComposicao').empty().trigger('change')
        $('#txtStatus').empty().trigger('change')
        $('#txtIcmsSaida').empty().trigger('change')
        $('#txtIcmsEntrada').empty().trigger('change')
        $('#txtIpiSaida').empty().trigger('change')
        $('#txtIpiEntrada').empty().trigger('change')
        $('#txtFaixa').empty().trigger('change')
        $('#txtCor').empty().trigger('change')
        $('#selectTipoVenda').val('')
        $('#selectPosse').val('')
    })

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (colunas == null || colunas.material == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, material: [] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    if (colunas == null || colunas.materialCores == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, materialCores: [] }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
    }

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
        let tabela = ''

        if (activeColVis == 'buttonColVisCapa') {
            tabela = '#tabelaCadMaterial'
        }
        if (activeColVis == 'buttonColVisItens') {
            tabela = '#tabelaCores'
        }
        $(tabela).DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text().trim(),
                'data': this.dataSrc()
            })
        });

        if (activeColVis == 'buttonColVisCapa') {
            adicionaColunas(cols, colunasInvisiveis.material ?? [], ['Pedido'])
        }
        if (activeColVis == 'buttonColVisItens') {
            adicionaColunas(cols, colunasInvisiveis.materialCores ?? [], [])

        }
    })

    const retornarFiltros = async () => {
        const filtros = {
            situacao: $('input[name="cbStatus"]:checked').val(),
            cadastroDe: $('#txtCadastroDe').val(),
            cadastroAte: $('#txtCadastroAte').val(),
            alteracaoDe: $('#txtAlteracaoDe').val(),
            alteracaoAte: $('#txtAlteracaooAte').val(),
            materiais: await formataListas($('#txtMaterial').val().toString()),
            grupos: await formataListas($('#txtGrupo').val().toString()),
            subgrupos: await formataListas($('#txtSubGrupo').val().toString()),
            linhas: await formataListas($('#txtLinha').val().toString()),
            ncms: await formataListas($('#txtNcm').val().toString()),
            clientes: await formataListas($('#txtClienteFornecedor').val().toString()),
            composicoes: await formataListas($('#txtComposicao').val().toString()),
            status: await formataListas($('#txtStatus').val().toString()),
            icmsSaida: await formataListas($('#txtIcmsSaida').val().toString()),
            icmsEntrada: await formataListas($('#txtIcmsEntrada').val().toString()),
            ipisSaida: await formataListas($('#txtIpiSaida').val().toString()),
            ipisEntrada: await formataListas($('#txtIpiEntrada').val().toString()),
            faixas: await formataListas($('#txtFaixa').val().toString()),
            cores: await formataListas($('#txtCor').val().toString()),
            tipoVenda: $('#selectTipoVenda').val(),
            posse: $('#selectPosse').val(),
        }

        return filtros
    }

    const retornarDados = (filtros) => {
        $.LoadingOverlay("show")
        requisicao('POST', '/Sisplan/material/v1/retornardadosacesso?', '', JSON.stringify(filtros), 3600000).then(async (response) => {
            if (!response) {
                return
            }

            const json = await response.json()

            if (json) {
                const { resultado, mensagem } = json
                if (mensagem?.codigo !== 200) {
                    throw mensagem?.mensagem
                }

                const { materiais } = resultado

                criarTabelaMateriais(materiais ?? [])
            }

        }).catch((error) => {
            console.error(error);
            msgErro('Ocorreu um erro ao buscar os dados.')
        }).finally(() => {
            $.LoadingOverlay('hide')
            $('#modal-filtros').modal('hide')
        })
    }

    const criarTabelaMateriais = (data) => {
        if ($.fn.DataTable.isDataTable('#tabelaCadMaterial')) {
            $('#tabelaCadMaterial').DataTable().destroy()
            $('#tabelaCadMaterial').empty()
        }

        const colunaSel = [0];

        function botaoSelecionarGrid(data, type, row, meta) {
            return `<div class="icheck-primary d-inline">
                        <input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="checkSel">
                        <label for="check_col_${meta.row}_row_${meta.col}"></label>
                    </div>`
        }

        const columns = [
            {
                title: `<div class="icheck-primary d-inline">
                        <input type="checkbox" id="cbSelAll">
                        <label for="cbSelAll"></label>
                      </div>
                      `,
                data: 'SEL'
            },
            {
                data: 'codigo',
                title: 'Código',
                render: function (data) {
                    return retornaBotaoOpcoes(data)
                }
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
            {
                data: 'grupo',
                title: 'Grupo',
            },
            {
                data: 'desc_grupo',
                title: 'Desc. Grupo',
            },
            {
                data: 'subgrupo',
                title: 'Subgrupo',
            },
            {
                data: 'desc_subgrupo',
                title: 'Desc. Subgrupo',
            },
            {
                data: 'ativo',
                title: 'Ativo',
            },
            {
                data: 'data_cad',
                title: 'Cadastro',
            },
            {
                data: 'preco',
                title: 'Preço',
            },
            {
                data: 'un_compra',
                title: 'Un. Compra',
            },
            {
                data: 'un_venda',
                title: 'Un. Venda',
            },
        ]

        $('#tabelaCadMaterial').DataTable({
            search: false,
            filter: true,
            order: [],
            sort: false,
            destroy: true,
            scrollX: true,
            scrollY: '55vh',
            pageLength: 25,
            paging: true,
            "autoWidth": true,
            "data": data,
            "columns": columns,
            autoWidth: false,
            "colReorder": true,
            "columnDefs": [
                {
                    render: botaoSelecionarGrid,
                    targets: colunaSel,
                }
            ]
        });

        $('#tabelaCadMaterial_length').prepend('<button class="buttonColVis" id="buttonColVisCapa"><i class="fas fa-cogs"></i></button>');
        $('#tabelaCadMaterial_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVisCapa').prop('title', 'Configurar colunas visíveis');
        $('#buttonExcel').prop('title', 'Exportar');

        $('#buttonColVisCapa').on('click', async function () {
            $.LoadingOverlay('show')
            try {
                activeColVis = 'buttonColVisCapa'
                $('#modal-ColunasVisiveis').modal('show');
            } finally {
                $.LoadingOverlay('hide')
            }
        });

        $("#btnConfirmarColunas").off();
        $("#btnConfirmarColunas").on("click", async function () {
            try {
                $.LoadingOverlay("show");
                let tabela = ''

                const novasColunas = retornaNovasColunasInvisiveis();
                if (activeColVis == 'buttonColVisCapa') {
                    tabela = '#tabelaCadMaterial'
                    localStorage.setItem(
                        "colunasInvisiveisRelatorios",
                        JSON.stringify({
                            ...colunas,
                            material: novasColunas,
                        })
                    );
                }
                if (activeColVis == 'buttonColVisItens') {
                    tabela = '#tabelaCores'
                    localStorage.setItem(
                        "colunasInvisiveisRelatorios",
                        JSON.stringify({
                            ...colunas,
                            materialCores: novasColunas,
                        })
                    );
                }

                $(tabela).DataTable().columns().visible(true);

                $(tabela)
                    .DataTable()
                    .columns()
                    .every(function () {
                        const colAtual = String(this.dataSrc());
                        if (novasColunas.indexOf(colAtual) != -1) {
                            this.visible(false);
                        }
                    });

            } finally {
                $.LoadingOverlay("hide");
                $("#modal-ColunasVisiveis").modal("hide");
            }
        });

        $('#buttonExcel').off()
        $('#buttonExcel').on('click', async function () {
            const dados = $("#tabelaCadMaterial").DataTable().data().toArray();
            await exportaCSV("", "", undefined, null, 'Relatório de Materiais', '', '', 999, false, false, dados);
        });

        adicionarEventoSelecionarTodos();

        $($($('#tabelaCadMaterial').children()[1]).children()[0]).trigger('click');
    }

    $('#tabelaCadMaterial').on('click', 'tr', async function () {
        const data = $('#tabelaCadMaterial').DataTable().row($(this)).data();

        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
        } else {
            $('#tabelaCadMaterial').DataTable().$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
        }

        await retornaCores(data.codigo);
    });

    $('#tabelaCadMaterial').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            event.preventDefault();
            var data = $('#tabelaCadMaterial').DataTable().row($(this).parents('tr')).data();
            var registroLiberado = await verificarRegistro('MATERIAL', data.codigo)
            if (registroLiberado) {
                window.location.href = "material/" + data.codigo
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCadMaterial').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            event.preventDefault();
            var data = $('#tabelaCadMaterial').DataTable().row($(this)).data();
            var registroLiberado = await verificarRegistro('MATERIAL', data.codigo)
            if (registroLiberado) {
                window.location.href = "material/" + data.codigo
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCadMaterial').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaCadMaterial").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    async function retornaCores(sCodigo) {
        $.LoadingOverlay('show');
        try {
            const dadosSelect = {
                tabela: 'MAT_ITEN',
                camposSelect: [
                    'DISTINCT MAT_ITEN.COR',
                    'CADCOR.DESCRICAO',
                    'CADCOR.PANTONE',
                    'CADCOR.CODIGO2',
                    'CADCOR.OBS',
                    'CADCOR.RGB',
                    'MAT_ITEN.ATIVO'
                ],
                leftJoin: [
                    { tabela: 'CADCOR ', condicao: 'MAT_ITEN.COR = CADCOR.COR' },
                ],
                where: [`MAT_ITEN.CODIGO = '${sCodigo}'`],
                orderBy: ['MAT_ITEN.COR']
            };
            const dados = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
            if (!dados) {
                msgAlerta('Não foi possível buscar os dados das cores.');
                return;
            }

            if ($.fn.DataTable.isDataTable('#tabelaCores')) {
                $('#tabelaCores').DataTable().destroy()
                $('#tabelaCores').empty()
            }

            const columns = [
                {
                    data: 'COR',
                    title: 'Cor',
                },
                {
                    data: 'DESCRICAO',
                    title: 'Descrição',
                },
                {
                    data: 'PANTONE',
                    title: 'Pantone',
                },
                {
                    data: 'CODIGO2',
                    title: 'Código 2',
                },
                {
                    data: 'OBS',
                    title: 'Observação',
                },
                {
                    data: 'RGB',
                    title: 'RBG',
                },
                {
                    data: 'ATIVO',
                    title: 'Ativo',
                },
            ]

            $('#tabelaCores').DataTable({
                search: false,
                filter: true,
                order: [],
                sort: false,
                destroy: true,
                scrollX: true,
                scrollY: '55vh',
                pageLength: 10,
                paging: true,
                "autoWidth": true,
                "data": dados,
                "columns": columns,
                autoWidth: false,
                "colReorder": true,
                columnDefs: [
                    {
                        targets: [5],
                        render: function (data, type, row) {
                            return retornaCampoRGB(row.RGB);
                        }
                    },
                ]
            });

            $('#tabelaCores_length').prepend('<button class="buttonColVis" id="buttonColVisItens"><i class="fas fa-cogs"></i></button>');
            $('#tabelaCores_length').prepend('<button class="buttonExcel" id="buttonExcel2"><i class="fas fa-file-excel"></i></button>');

            $('#buttonColVisItens').prop('title', 'Configurar colunas visíveis');
            $('#buttonExcel2').prop('title', 'Exportar');

            $('#buttonColVisItens').on('click', async function () {
                $.LoadingOverlay('show')
                try {
                    activeColVis = 'buttonColVisItens'
                    $('#modal-ColunasVisiveis').modal('show');
                } finally {
                    $.LoadingOverlay('hide')
                }
            });

            $('#buttonExcel2').off()
            $('#buttonExcel2').on('click', async function () {
                const dados = $("#tabelaCores").DataTable().data().toArray();
                await exportaCSV("", "", undefined, null, 'Relatório de Cores de Material', '', '', 999, false, false, dados);
            });
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    function retornaCampoRGB(rgb) {
        const r = rgb.substring(0, 3);
        const g = rgb.substring(3, 6);
        const b = rgb.substring(6, 9);

        const hexR = ("0" + parseInt(r, 10).toString(16)).slice(-2);
        const hexG = ("0" + parseInt(g, 10).toString(16)).slice(-2);
        const hexB = ("0" + parseInt(b, 10).toString(16)).slice(-2);

        const hex = '#' + hexR + hexG + hexB;

        var retorno = '<div class="form-group" style="margin-bottom: 0.2rem !important; margin-top: 0.2rem !important"> ' +
            `     <input type="color" disabled class="input-default" value="${hex}" id="inputColorRGBAcesso"></input>` +
            '</div>';

        return retorno;
    };

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/material?", `CODIGOMATERIAL=${encodeURIComponent(valorLinha.codigo)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $("#tabelaCadMaterial").on('click', "#btnAnexos", async function () {
        const data = $('#tabelaCadMaterial').DataTable().rows($(this).parents('tr')).data();

        await abreModalAnexos(data[0].codigo, data[0].DESCRICAO, 'MATERIAL');
    });

    $('#tabelaCadMaterial').on('click', "#btn-duplicar", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaCadMaterial').DataTable().row($(this).parents('tr')).data();
            await duplicaCadastroMaterial(data.codigo);
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCadMaterial').on('click', '#btnMatItensEst', function () {
        const data = $('#tabelaCadMaterial').DataTable().row($(this).parents('tr')).data();
        abreMatItensEst(data.codigo);
    });

    $("#tabelaCadMaterial").on('change', '.checkSel', function () {
        const linha = $(this).closest('tr')
        const isChecked = this.checked
        $(linha).toggleClass('selectedCheck', isChecked);
        $(this).closest('tr').trigger('click');
    })

    function adicionarEventoSelecionarTodos() {
        $('#cbSelAll').off('change')
        $('#cbSelAll').on('change', function () {
            const isChecked = this.checked
            const table = $('#tabelaCadMaterial').DataTable()
            table.rows().every(function () {
                const row = $(this.node())
                row.toggleClass('selectedCheck', isChecked)
                const checkbox = row.find('.checkSel')
                checkbox.prop('checked', isChecked)
            })
        })
    }

    componenteFiltro('material', true)
    componenteFiltro('grupo', true)
    componenteFiltro('subGrupo', true)
    componenteFiltro('linha', true)
    componenteFiltro('ncm', true)
    componenteFiltro('cliente', true, true, 'ClienteFornecedor')
    componenteFiltro('composicaoMaterial', true, true, 'Composicao')
    componenteFiltro('status', true)
    componenteFiltro('cstIcms', true, true, 'IcmsSaida')
    componenteFiltro('cstIcms', true, true, 'IcmsEntrada')
    componenteFiltro('cstIpi', true, true, 'IpiSaida')
    componenteFiltro('cstIpi', true, true, 'IpiEntrada')
    componenteFiltro('cor', true)
    componenteFiltro('faixaMaterial', true, true, 'Faixa')

    componenteFiltro('status', false, false, 'StatusAlterarDados')
    componenteFiltro('grupo', false, false, 'GrupoAlterarDados')
    componenteFiltro('subGrupo', false, false, 'SubgrupoAlterarDados')
    componenteFiltro('linha', false, false, 'LinhaAlterarDados')
    componenteFiltro('composicaoMaterial', false, false, 'ComposicaoAlterarDados')
    componenteFiltro('entidade', false, false, 'ClienteFornecedorAlterarDados')
    componenteFiltro('cstIcms', false, false, 'CstIcmsSaidaAlterarDados')
    componenteFiltro('cstIcms', false, false, 'CstIcmsEntradaAlterarDados')
    componenteFiltro('cstIpi', false, false, 'CstIpiSaidaAlterarDados')
    componenteFiltro('cstIpi', false, false, 'CstIpiEntradaAlterarDados')
    componenteFiltro('enquadramentoIpi', false, false, 'EnquadramentoIpiAlterarDados')

    $('#btnConfirmarAlterarDados').on('click', () => msgAlerta(
        'Deseja atualizar os dados de todos os registros selecionados?',
        () => null,
        () => null,
        () => confirmarAlterarDados(),
    ))

    const confirmarAlterarDados = async () => {
        const dadosAlteracao = retornarDadosAlteracao()
        if (!dadosAlteracao) return
        alterarDados(dadosAlteracao).then((resultado) => {
            if (!resultado || resultado !== 'OK') throw ''

            toastr.success("Dados gravados com sucesso!", "Confirmação", {
                toastClass: "alert",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 1000,
                fadeOut: 1000,
                onShown() {
                    $('#btnConsultar').trigger('click')
                },
                onHidden() {
                    $('#modalAlterarDadosEmMassa').modal('hide')
                },
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            })
        }).catch((error) => {
            console.error(error)
            msgErro('Ocorreu um erro ao gravar os dados, tente novamente.')
        })
    }

    const retornarDadosAlteracao = () => {
        const codigo2 = $('#txtCodigo2AlterarDados').val()
        const descricao = $('#txtDescricaoAlterarDados').val()
        const descricao2 = $('#txtDescricao2AlterarDados').val()
        const status = pegaChave('#txtStatusAlterarDados')
        const grupo = pegaChave('#txtGrupoAlterarDados')
        const subgrupo = pegaChave('#txtSubgrupoAlterarDados')
        const linha = pegaChave('#txtLinhaAlterarDados')
        const composicao = pegaChave('#txtComposicaoAlterarDados')
        const cliente = pegaChave('#txtClienteFornecedorAlterarDados')
        const cstIcmsSaida = pegaChave('#txtCstIcmsSaidaAlterarDados')
        const cstIcmsEntrada = pegaChave('#txtCstIcmsEntradaAlterarDados')
        const cstIpiSaida = pegaChave('#txtCstIpiSaidaAlterarDados')
        const cstIpiEntrada = pegaChave('#txtCstIpiEntradaAlterarDados')
        const enquadramentoIpi = pegaChave('#txtEnquadramentoIpiAlterarDados')
        const posse = $('#selectPosseAlterarDados').val()
        const ativo = $('#selectAtivoAlterarDados').val()

        const dadosAlteracao = {
            codigo2,
            descricao,
            descricao2,
            status,
            grupo,
            subgrupo,
            linha,
            composicao,
            cliente,
            cstIcmsSaida,
            cstIcmsEntrada,
            cstIpiSaida,
            cstIpiEntrada,
            enquadramentoIpi,
            posse,
            ativo,
        }

        const materiaisAlteracao = $('#tabelaCadMaterial').DataTable().rows('.selectedCheck').data().toArray().filter((e) => e.codigo)

        return {
            dadosAlteracao,
            materiaisAlteracao,
        }
    }

    const alterarDados = async (dados) => {
        try {
            $.LoadingOverlay('show')
            const response = await requisicao(
                'POST',
                `/sisplan/material/v1/atualizardadosmateriaisemmassa?`,
                '',
                JSON.stringify(dados),
                3600000
            )

            const json = await response.json()

            if (json) {
                const { resultado, mensagem } = json
                if (mensagem?.codigo !== 200) {
                    throw mensagem?.mensagem
                }

                return resultado
            }
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    $('#btnAlterarDadosEmMassa').on('click', () => {
        if ($('#tabelaCadMaterial').DataTable().rows('.selectedCheck').data().toArray()?.length > 0)
            $('#modalAlterarDadosEmMassa').modal('show')
        else
            msgErro('Nenhum registro selecionado, impossível continuar.')
    })
    $('#modalAlterarDadosEmMassa').on('hide.bs.modal', () => $('.campoAlterarDadosEmMassa').val(''))
    $('#btnLimparCamposAlterarDados').on('click', () => $('.campoAlterarDadosEmMassa').val(''))

    $('#txtDescricaoAlterarDados').on('input', function () {
        $(this).val($(this).val().replace(/"/g, ''));
    })

    componenteFiltro('material', true, true, 'MaterialUtilizacao')
    componenteFiltro('grupo', true, true, 'GrupoUtilizacao')
    componenteFiltro('subGrupo', true, true, 'SubgrupoUtilizacao')
    componenteFiltro('linha', true, true, 'LinhaUtilizacao')
    componenteFiltro('status', true, true, 'StatusUtilizacao')
    componenteFiltro('cor', true, true, 'CorUtilizacao')

    $('#btnUtilizacao').on('click', () => carregarModalUtilizacao())

    const carregarModalUtilizacao = () => {
        $('#modalUtilizacao').modal('show')
        const registrosSelecionados = $('#tabelaCadMaterial').DataTable().rows('.selectedCheck').data().toArray()
        if (registrosSelecionados.length > 0) {
            $('#modalUtilizacao').on('shown.bs.modal', function () {
                $('#tabelaItensUtilizacao').DataTable().columns.adjust().draw()
                $('#tabelaProdutosUtilizacao').DataTable().columns.adjust().draw()
                $('#tabelaCoresUtilizacao').DataTable().columns.adjust().draw()
            })
            const filtros = {
                materiais: registrosSelecionados.map((e) => `'${e.codigo}'`).join(',')
            }
            retornarUtilizacaoMateriaisSelecionados(filtros)
        }
    }

    $('#modalUtilizacao').on('hide.bs.modal', () => {
        if ($.fn.DataTable.isDataTable('#tabelaItensUtilizacao')) {
            $('#tabelaItensUtilizacao').DataTable().destroy()
            $('#tabelaItensUtilizacao').empty()
        }

        if ($.fn.DataTable.isDataTable('#tabelaProdutosUtilizacao')) {
            $('#tabelaProdutosUtilizacao').DataTable().destroy()
            $('#tabelaProdutosUtilizacao').empty()
        }

        if ($.fn.DataTable.isDataTable('#tabelaCoresUtilizacao')) {
            $('#tabelaCoresUtilizacao').DataTable().destroy()
            $('#tabelaCoresUtilizacao').empty()
        }
        limparFiltrosUtilizacao()
        $('#modalUtilizacao').off('shown.bs.modal')
    })

    $('#btnConsultarUtilizacao').on('click', () => consultarUtilizacao())

    const consultarUtilizacao = () => {
        retornarFiltrosUtilizacao().then((filtros) => filtros && retornarDadosUtilizacao(filtros))
    }

    const retornarFiltrosUtilizacao = async () => {
        const filtros = {
            materiais: await formataListas($('#txtMaterialUtilizacao').val().toString()),
            grupos: await formataListas($('#txtGrupoUtilizacao').val().toString()),
            subgrupos: await formataListas($('#txtSubgrupoUtilizacao').val().toString()),
            linhas: await formataListas($('#txtLinhaUtilizacao').val().toString()),
            status: await formataListas($('#txtStatusUtilizacao').val().toString()),
            cores: await formataListas($('#txtCorUtilizacao').val().toString()),
            situacao: $('#selectSituacaoUtilizacao').val(),
            situacaoCor: $('#selectSituacaoCorUtilizacao').val(),
        }

        return filtros
    }

    const retornarDadosUtilizacao = (filtros) => {
        $.LoadingOverlay('show')
        requisicao(
            'POST',
            `/sisplan/material/v1/retornardadosutilizacao?`,
            '',
            JSON.stringify(filtros),
            3600000
        ).then(async (response) => {
            const dados = await response.json()
            if (dados) {
                const { resultado, mensagem } = dados
                if (mensagem?.codigo !== 200) {
                    throw mensagem?.mensagem
                }

                if (!resultado) return
                const { itens, produtos, cores } = resultado

                if (!itens || !itens.length) {
                    msgErro('Nenhum item encontrado.')
                }

                criarTabelaItensUtilizacao(itens ?? [])
                criarTabelaProdutosUtilizacao(produtos ?? [])
                criarTabelaCoresUtilizacao(cores ?? [])
            }
        }).catch((error) => {
            console.error(error)
            msgErro('Ocorreu um erro ao buscar os dados.')
        }).finally(() => $.LoadingOverlay('hide'))
    }

    const retornarDadosItemUtilizacao = (insumo, situacaoCor) => {
        $.LoadingOverlay('show')
        requisicao(
            'GET',
            `/sisplan/material/v1/retornardadositemutilizacao?`,
            `INSUMO=${encodeURIComponent(insumo)}&SITUACAO_COR=${encodeURIComponent(situacaoCor)}`,
            '',
            3600000
        ).then(async (response) => {
            const dados = await response.json()
            if (dados) {
                const { resultado, mensagem } = dados
                if (mensagem?.codigo !== 200) {
                    throw mensagem?.mensagem
                }

                if (!resultado) return
                const { produtos, cores } = resultado

                if (!produtos || !produtos.length) {
                    msgErro('Nenhum produto encontrado.')
                }

                criarTabelaProdutosUtilizacao(produtos ?? [])
                criarTabelaCoresUtilizacao(cores ?? [])
            }
        }).catch((error) => {
            console.error(error)
            msgErro('Ocorreu um erro ao buscar os dados.')
        }).finally(() => $.LoadingOverlay('hide'))
    }

    const retornarDadosProdutoUtilizacao = (insumo, produto, situacaoCor) => {
        $.LoadingOverlay('show')
        requisicao(
            'GET',
            `/sisplan/material/v1/retornardadosprodutoutilizacao?`,
            `INSUMO=${encodeURIComponent(insumo)}&PRODUTO=${encodeURIComponent(produto)}&SITUACAO_COR=${encodeURIComponent(situacaoCor)}`,
            '',
            3600000
        ).then(async (response) => {
            const dados = await response.json()
            if (dados) {
                const { resultado, mensagem } = dados
                if (mensagem?.codigo !== 200) {
                    throw mensagem?.mensagem
                }

                if (!resultado) return
                const { cores } = resultado

                if (!cores || !cores.length) {
                    msgErro('Nenhuma cor encontrada.')
                }

                criarTabelaCoresUtilizacao(cores ?? [])
            }
        }).catch((error) => {
            console.error(error)
            msgErro('Ocorreu um erro ao buscar os dados.')
        }).finally(() => $.LoadingOverlay('hide'))
    }

    const criarTabelaItensUtilizacao = (data) => {
        if ($.fn.DataTable.isDataTable('#tabelaItensUtilizacao')) {
            $('#tabelaItensUtilizacao').DataTable().destroy()
            $('#tabelaItensUtilizacao').empty()
        }

        const columns = [
            {
                data: 'codigo',
                title: 'Código',
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
        ]

        const table = $('#tabelaItensUtilizacao').DataTable({
            sort: false,
            paging: false,
            destroy: true,
            lengthChange: false,
            filter: false,
            info: false,
            ordering: false,
            sorting: false,
            order: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '150px',
            select: {
                style: 'single',
                toggleable: false,
            },
        })
        table.off('select')
        $('#tabelaItensUtilizacao').DataTable().row(':first').select()

        table.on('select', function (_e, _dt, type, indexes) {
            if (type === 'row') {
                const data = table.rows(indexes[0]).data().toArray()
                const situacaoCor = $('#selectSituacaoCorUtilizacao').val()
                retornarDadosItemUtilizacao(data[0]?.codigo, situacaoCor)
            }
        })
    }

    const criarTabelaProdutosUtilizacao = (data) => {
        if ($.fn.DataTable.isDataTable('#tabelaProdutosUtilizacao')) {
            $('#tabelaProdutosUtilizacao').DataTable().destroy()
            $('#tabelaProdutosUtilizacao').empty()
        }

        const columns = [
            {
                data: 'codigo',
                title: 'Código',
            },
            {
                data: 'descricao',
                title: 'Descrição',
            },
            {
                data: 'consumoUnitario',
                title: 'Consumo Unitário',
                render: function (data) {
                    if (!data) {
                        return parseFloat(0).toLocaleString("pt-br", {
                            maximumFractionDigits: 6,
                            minimumFractionDigits: 6,
                        })
                    }
                    return parseFloat(data).toLocaleString("pt-br", {
                        maximumFractionDigits: 6,
                        minimumFractionDigits: 6,
                    })
                },
                className: 'text-right pr-2'
            },
            {
                data: 'ativo',
                title: 'Ativo',
            },
            {
                data: 'codigo2',
                title: 'Código 2',
            },
            {
                data: 'colecao',
                title: 'Coleção',
            },
            {
                data: 'descricaoColecao',
                title: 'Descrição Coleção',
            },
            {
                data: 'tipo',
                title: 'Tipo',
            },
            {
                data: 'linha',
                title: 'Linha',
            },
            {
                data: 'descricaoLinha',
                title: 'Descrição Linha',
            },
            {
                data: 'dataCadastroProduto',
                title: 'Data Cadastro Produto',
                type: 'date-br',
                render(data) {
                    return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split('T')[0]} 23:59:59`));
                }
            },
        ]

        const table = $('#tabelaProdutosUtilizacao').DataTable({
            sort: false,
            paging: false,
            destroy: true,
            lengthChange: false,
            filter: false,
            info: false,
            ordering: false,
            sorting: false,
            order: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '210px',
            select: {
                style: 'single',
                toggleable: false,
            },
        })
        table.off('select')
        $('#tabelaProdutosUtilizacao').DataTable().row(':first').select()

        table.on('select', function (_e, _dt, type, indexes) {
            if (type === 'row') {
                const data = table.rows(indexes[0]).data().toArray()
                const situacaoCor = $('#selectSituacaoCorUtilizacao').val()
                const datatableItens = $('#tabelaItensUtilizacao').DataTable()
                const [selectedRowIndex] = datatableItens?.rows({ selectedCheck: true }).indexes().toArray()
                const insumo = datatableItens?.row(selectedRowIndex)?.data()?.codigo || ''
                retornarDadosProdutoUtilizacao(insumo, data[0]?.codigo, situacaoCor)
            }
        })
    }

    const criarTabelaCoresUtilizacao = (data) => {
        if ($.fn.DataTable.isDataTable('#tabelaCoresUtilizacao')) {
            $('#tabelaCoresUtilizacao').DataTable().destroy()
            $('#tabelaCoresUtilizacao').empty()
        }

        const columns = [
            {
                data: 'codigo',
                title: 'Código',
            },
            {
                data: 'cor',
                title: 'Cor',
            },
            {
                data: 'descricaoCor',
                title: 'Descrição Cor',
            },
        ]

        $('#tabelaCoresUtilizacao').DataTable({
            sort: false,
            paging: false,
            destroy: true,
            lengthChange: false,
            filter: false,
            info: false,
            ordering: false,
            sorting: false,
            order: false,
            autoWidth: true,
            data,
            columns,
            scrollX: true,
            scrollY: '150px',
        })
    }

    $('#btnLimparFiltrosUtilizacao').on('click', () => limparFiltrosUtilizacao())

    const limparFiltrosUtilizacao = () => {
        $('#txtMaterialUtilizacao').empty().trigger('change')
        $('#txtGrupoUtilizacao').empty().trigger('change')
        $('#txtSubgrupoUtilizacao').empty().trigger('change')
        $('#txtLinhaUtilizacao').empty().trigger('change')
        $('#txtStatusUtilizacao').empty().trigger('change')
        $('#txtCorUtilizacao').empty().trigger('change')
        $('#selectSituacaoUtilizacao').val('')
        $('#selectSituacaoCorUtilizacao').val('')
    }

    const retornarUtilizacaoMateriaisSelecionados = (filtros) => {
        $.LoadingOverlay('show')
        requisicao(
            'POST',
            `/sisplan/material/v1/retornardadosutilizacaomateriaisselecionados?`,
            '',
            JSON.stringify(filtros),
            3600000
        ).then(async (response) => {
            const dados = await response.json()
            if (dados) {
                const { resultado, mensagem } = dados
                if (mensagem?.codigo !== 200) {
                    throw mensagem?.mensagem
                }

                if (!resultado) return
                const { itens, produtos, cores, materiaisSelecionados } = resultado

                materiaisSelecionados.forEach((item) => adicionaValorPadraoVarios('materialUtilizacao', item.codigo, item.descricao))

                if (!itens || !itens.length) {
                    msgErro('Nenhum item encontrado.')
                }

                criarTabelaItensUtilizacao(itens ?? [])
                criarTabelaProdutosUtilizacao(produtos ?? [])
                criarTabelaCoresUtilizacao(cores ?? [])
            }
        }).catch((error) => {
            console.error(error)
            msgErro('Ocorreu um erro ao buscar os dados.')
        }).finally(() => $.LoadingOverlay('hide'))
    }

    const retornaFiltrosImpressao = async () => {
        const filtros = `SITUACAO=${$('input[name="cbStatus"]:checked').val()}` +
            `&CADASTRODE=${$('#txtCadastroDe').val()}` +
            `&CADASTROATE=${$('#txtCadastroAte').val()}` +
            `&ALTERACAODE=${$('#txtAlteracaoDe').val()}` +
            `&ALTERACAOATE=${$('#txtAlteracaoAte').val()}` +
            `&MATERIAIS=${await formataListas($('#txtMaterial').val().toString())}` +
            `&GRUPOS=${await formataListas($('#txtGrupo').val().toString())}` +
            `&SUBGRUPOS=${await formataListas($('#txtSubGrupo').val().toString())}` +
            `&LINHAS=${await formataListas($('#txtLinha').val().toString())}` +
            `&NCMS=${await formataListas($('#txtNcm').val().toString())}` +
            `&CLIENTES=${await formataListas($('#txtClienteFornecedor').val().toString())}` +
            `&COMPOSICOES=${await formataListas($('#txtComposicao').val().toString())}` +
            `&STATUS=${await formataListas($('#txtStatus').val().toString())}` +
            `&ICMSSAIDA=${await formataListas($('#txtIcmsSaida').val().toString())}` +
            `&ICMSENTRADA=${await formataListas($('#txtIcmsEntrada').val().toString())}` +
            `&IPISSAIDA=${await formataListas($('#txtIpiSaida').val().toString())}` +
            `&IPISENTRADA=${await formataListas($('#txtIpiEntrada').val().toString())}` +
            `&FAIXAS=${await formataListas($('#txtFaixa').val().toString())}` +
            `&CORES=${await formataListas($('#txtCor').val().toString())}` +
            `&TIPOVENDA=${$('#selectTipoVenda').val()}` +
            `&POSSE=${$('#selectPosse').val()}`

        return filtros
    }

    retornaHintRelatorio('btnImprimirAcessoMat', 'RelAcessoMaterial')
    preencheOrdenacaoTela('RelAcessoMaterial')

    $('#btnImprimirAcessoMat').on('click', async function () {
        let str = $('#tabelaCadProduto_info').text();
        str = str.replace('.', '').replace(',', '');
        let endIndex = str.indexOf(' registro');

        let contadorRegistros = parseFloat(str.substring(0, endIndex));

        if (parseFloat(contadorRegistros) > 1000) {
            msgAlerta(`Existem ${contadorRegistros} materiais filtrados, a impressão poderá demorar. Deseja Continuar?`, async () =>
                await imprimirAcessoMat()
            )
        } else {
            await imprimirAcessoMat()
        }
    });

    async function imprimirAcessoMat() {
        try {
            $.LoadingOverlay('show');
            try {
                const url = `/sisplan/impressao/v1/imprimiracessomaterial?`;
                const filtros = await retornaFiltrosImpressao();
                const ordem = `&TELA_ORDENACAO=RelAcessoMaterial&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelAcessoMaterial');
                const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 3600000, false, 'RelAcessoMaterial');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#tabelaCadMaterial').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaCadMaterial").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    $('#tabelaCadMaterial').on('click', "#btnImprimir", async function () {
        try {
            $.LoadingOverlay("show");
            const data = $('#tabelaCadMaterial').DataTable().row($(this).parents('tr')).data();
            const codigo = data.codigo
            const url = `/sisplan/impressao/v1/imprimirmaterialindividual?CODIGO=${codigo}`;
            const bImprimeAutomatico = await verificaImprimirAutomatico('RelMaterialIndividual');
            let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'RelMaterialIndividual');
            if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                }
                await limparRelatorios();
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });
});
