$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });
        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para realizar a movimentação.',
                position: 'top'
            }
        },
        {
            element: '#txtDocumento',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtTipoSaida',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtQualidade',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtDeposito',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtBarra',
            popover: {
                title: 'Campo Barra',
                description: 'Aqui você irá bipar o produto que será dado entrada.',
                position: 'top'
            }
        },
        {
            element: '#tabela-movimentados',
            popover: {
                title: 'Tabela Produtos',
                description: 'Aqui ficam os produtos bipados.',
                position: 'top'
            }
        },
        {
            element: '#confirmar_mov',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a movimentação.',
                position: 'top'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    let listaBarrasBipadas = [];
    const parametrosSistema = await BuscaParametrosSistema();
    const utilizaBarraLog = parametrosSistema[0].VALOR != 0;
    const bApenasBarraLog = parametrosSistema[0].VALOR == 2;

    await buscaValoresPadroesTela();

    await setarDataAtual('txtDataMovimentoSaida');

    let codigoSaidasManual = '';

    async function carregaTipoSaida() {
        const pesquisaParam = {
            tabela: 'TABBAI',
            camposSelect: ['CODIGO', 'DESCRICAO', 'TIPO', 'ATIVO'],
            where: [`ATIVO = 'S'`],
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        let saidasManual = '';

        jsonStr.forEach(tipoBaixa => {
            if (tipoBaixa.TIPO && tipoBaixa.TIPO.charAt(9) === 'S') {
                saidasManual += saidasManual ? `,'${tipoBaixa.CODIGO}'` : `'${tipoBaixa.CODIGO}'`;
            }
        });

        codigoSaidasManual = saidasManual;
    }

    await carregaTipoSaida();

    $("#txtPrecoSped").maskMoney({
        decimal: ".",
        thousands: "",
        precision: 2,
    });

    let tabelaGrade = $('#tabela-grade').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        autoWidth: true,
        destroy: true,
    });

    await setarDataAtual('txtDataDe');
    await setarDataAtual('txtDataAte');
    $('#txtQuantidadeBipada').val(0);

    async function filtraGrade() {
        if (($('#txtProduto').val() != '') && ($('#txtCor').val() != '') && ($('#txtCor').val().substr(0, 1) == '[')) {
            let dataSet = await RetornaGradeProd();
            $('#tabela-grade').DataTable().rows().remove().draw(false);
            for (let i = 0; i < dataSet.length; i++) {
                const grade = dataSet[i];
                tabelaGrade.row.add([grade.TAM, grade.ESTOQUE, grade.EXPEDICAO, grade.RESERVA, grade.QUANTIDADE, `<input class="input-default" style="width:150px;" type="number" min="0" max="${grade.QUANTIDADE > 0 ? grade.QUANTIDADE : 0}"/>`, grade.ID]).draw(false);
            }

            $('#modal-grade').modal('show');
        }
        ajustaCusto();
    };

    function ajustaCusto() {
        const custo = $('#txtPrecoSped').val();
        if (custo.split('').includes(',')) {
            $('#txtPrecoSped').val((parseFloat((custo).replace(',', '.'))).toFixed(2));
        }
    }

    $('#modal-grade').on('hidden.bs.modal', function () {
        limpaCampos();
    });

    async function RetornaGradeProd() {
        let sCodigo = pegaChave('#txtProduto');
        let sDeposito = pegaChave('#txtDeposito');
        let sCor = pegaChave('#txtCor');
        let sQualidade = pegaChave('#txtQualidade');
        const tipo = sQualidade == '' ? sQualidade : ` and pa_iten.tipo = '${sQualidade}'`;
        let url = `/sisplan/funcoes/v1/pesquisa?`;
        let params = `JSON={
                    "tabela":"pa_iten",
                    "camposSelectSubSelect": ["TAM", "ESTOQUE", "EXPEDICAO", "RESERVA", "SUM(ESTOQUE - EXPEDICAO - RESERVA) QUANTIDADE, ID"], 
                    "groupBySubSelect": ["TAM, EXPEDICAO, RESERVA, ID, ESTOQUE"],
                    "camposSelect":[ "pa_iten.tam", `+
            `" COALESCE ((SELECT UDF_NVL(SUM(QUANTIDADE)) QTDE ` +
            ` FROM [PA_ITEN] PA_ITEN_QTDE ` +
            ` WHERE PA_ITEN_QTDE.CODIGO = PA_ITEN.CODIGO ` +
            ` AND PA_ITEN_QTDE.COR = PA_ITEN.COR ` +
            ` AND PA_ITEN_QTDE.TAM = PA_ITEN.TAM ` +
            ` AND PA_ITEN_QTDE.DEPOSITO='${sDeposito}' ` +
            ` AND PA_ITEN_QTDE.TIPO='${sQualidade}'), 0) ESTOQUE,` +
            ` COALESCE ((SELECT SUM(PEDIDO3.QTDE) ` +
            ` FROM [PEDIDO3] PEDIDO3` +
            ` WHERE PEDIDO3.CODIGO    = '${sCodigo}'` +
            ` AND PEDIDO3.COR       = '${sCor}'` +
            ` AND PEDIDO3.QUALIDADE = '${sQualidade}'` +
            ` AND PEDIDO3.DEPOSITO  = '${sDeposito}'` +
            ` AND PEDIDO3.TAM       = PA_ITEN.TAM ` +
            ` AND PEDIDO3.LOTE      = PA_ITEN.LOTE ` +
            ` AND PEDIDO3.QTDE      > 0), 0) EXPEDICAO, ` +
            ` COALESCE ((SELECT SUM(QTDE) QTDE ` +
            ` FROM [PED_RESERVA] PED_RESERVA` +
            ` WHERE CODIGO = PA_ITEN.CODIGO ` +
            ` AND COR = PA_ITEN.COR ` +
            ` AND LOTE = PA_ITEN.LOTE ` +
            ` AND TAM = PA_ITEN.TAM ` +
            ` AND QUAL = PA_ITEN.TIPO` +
            ` AND DEPOSITO = PA_ITEN.DEPOSITO ` +
            ` HAVING SUM(QTDE) > 0), 0) RESERVA,` +
            `PA_ITEN.ID"],
                        "leftjoin": [{ "tabela" : "produto", "condicao" : "pa_iten.codigo = produto.codigo" }, 
                                     { "tabela" : "faixa_iten", "condicao" : "faixa_iten.faixa = produto.faixa and faixa_iten.tamanho = pa_iten.tam" }], 
                        "groupby": ["pa_iten.codigo", "pa_iten.cor", "pa_iten.tam", "faixa_iten.posicao", "pa_iten.id", "pa_iten.LOTE", "pa_iten.TIPO", "pa_iten.DEPOSITO"],
                        "where": ["pa_iten.codigo = '${sCodigo}' and pa_iten.cor='${sCor}' and pa_iten.deposito = '${sDeposito}' ${tipo}"]}`;

        try {
            let response = await requisicao('GET', url, params, null);

            if (!response) {
                return '';
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return '';
            }

            const arrDados = jsonStr.RESULT[0];
            return arrDados;
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar os dados da venda.');
            return '';
        }
    }

    $('#txtTipoSaida').autocompleta(1, `JSON={ "tabela":"tabbai", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["CODIGO IN (${codigoSaidasManual})"] }`, [], [], []);
    $('#btnTipoSaida').on('click', function () {
        if (!codigoSaidasManual) {
            msgErro('Não existe Tipo Saída cadastrada como Saída Manual na tela "Tipo Baixa" para essa consulta.');
            return;
        }

        $('#btnTipoSaida').pesquisa_array(['#txtTipoSaida'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${codigoSaidasManual})"]}`, 'Pesquisa Tipo Entrada', 'TABBAI');
    });
    $('#btnLimpaTipoSaida').on('click', function () {
        $('#txtTipoSaida').val('');
    });

    $('#txtQualidade').autocompleta(1, `JSON={ "tabela":"tabqul", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
    $('#btnQualidade').pesquisa_array(['#txtQualidade'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabqul", "camposSelect":[ "codigo", "descricao" ], "where": null}', 'Pesquisa Qualidade', 'tabqul');
    $('#btnLimpaQualidade').on('click', function () {
        $('#txtQualidade').val('');
    });

    $('#txtFuncionario').autocompleta(1, `JSON={ "tabela":"PESSOAL", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": [] }`, [], [], []);
    $('#btnFuncionario').pesquisa_array(['#txtFuncionario'], ['CODIGO'], ['NOME'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PESSOAL", "camposSelect":[ "CODIGO", "NOME" ], "where": ["ATIVO = 'S'"]}`, 'Pesquisa Funcionário', 'PESSOAL');
    $('#btnLimpaFuncionario').on('click', function () {
        $('#txtFuncionario').val('');
    });

    componenteFiltro('cliente', false, false)

    const depositosEmpresaLogada = await verificaDepositosEmpresaLogada(getCookie('empresa'));
    const json = await retornaJsonPesquisaPadrao(`{"tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["EMPRESA <> ''"] }`);
    const depositoUsuario = await retornaDepositoUsuario(getCookie('cod_usuario'));

    if (depositoUsuario != 'null') {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ${depositoUsuario}}`, [], [], []);
        $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ${depositoUsuario}}`, 'Pesquisa Depósito', 'DEPOSITO');
        rotinaSaidaDeposito()
        $('#txtDeposito').trigger('blur')
    } else if (depositosEmpresaLogada != '') {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["CODIGO IN (${depositosEmpresaLogada})"] }`, [], [], []);
        $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${depositosEmpresaLogada})"]}`, 'Pesquisa Depósito', 'DEPOSITO');
        rotinaSaidaDeposito()
        $('#txtDeposito').trigger('blur')
    } else if (json.length == 0) {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
        $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": []}`, 'Pesquisa Depósito', 'DEPOSITO');
        rotinaSaidaDeposito()
        $('#txtDeposito').trigger('blur')
    } else {
        $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"] }`, [], [], []);
        $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"]}`, 'Pesquisa Depósito', 'DEPOSITO');
        rotinaSaidaDeposito()
        $('#txtDeposito').trigger('blur')
    }

    $('#btnLimpaDeposito').on('click', function () {
        $('#txtDeposito').val('');
    });

    // $('#txtProduto').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":["CODIGO CHAVE, DESCRICAO, CUSTO"], "where": [] }`, ['#txtPrecoSped'], ['CUSTO'], ['CUSTO'], filtraGrade, [true]);
    // // $('#btnProduto').pesquisa_array(['#txtProduto', '#txtPrecoSped'], ['CODIGO', 'CUSTO'], ['DESCRICAO', 'CUSTO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"produto", "camposSelect":[ "codigo", "descricao", "custo" ], "where": null}', 'Pesquisa Produto', 'produto', filtraGrade, [false, true]);
    // // $('#btnProduto').pesquisa_serverside(['#txtProduto', '#txtPrecoSped'], ['CODIGO', 'CUSTO'], ['DESCRICAO', 'CUSTO'], `{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CUSTO" ], "where": null}`, 'Pesquisa Produto', filtraGrade, [false, true]);
    // $('#btnProduto').pesquisa_serverside(['#txtProduto', '#txtPrecoSped'], ['CODIGO', 'CUSTO', 'CODIGO2'], ['DESCRICAO', 'CUSTO', 'CODIGO2'], '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CUSTO", "CODIGO2" ], "camposWhereServerSide":["CODIGO", "DESCRICAO", "CODIGO2"], "where": null}', 'Pesquisa Produto', filtraGrade, [false, true]);
    // $('#btnLimpaProduto').on('click', function () {
    //     $('#txtProduto').val('');
    // });

    // $('#txtCor').autocompleta(1, `JSON={ "tabela":"cadcor", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`, [], [], [], filtraGrade);
    // $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadcor", "camposSelect":[ "cor", "descricao" ], "where": null}', 'Pesquisa Cor', 'cadcor', filtraGrade);
    // $('#btnLimpaCor').on('click', function () {
    //     $('#txtCor').val('');
    // });

    // $('#txtProduto').on('blur', function () {
    //     // $('#txtCor').off();
    //     $('#txtCor').unbind('autocompleta');
    //     $('#txtCor').autocompleta(1, `JSON={ "tabela":"PA_ITEN", "camposSelect":["PA_ITEN.COR CHAVE, CADCOR.DESCRICAO"], "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR" }], "groupBy": ["PA_ITEN.COR", "CADCOR.DESCRICAO"], "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"] }`, [], [], [], filtraGrade);
    //     $('#btnCor').off();
    //     $('#btnCor').unbind('pesquisa_array');
    //     $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"pa_iten", "camposSelect":[ "pa_iten.cor", "cadcor.descricao" ],"leftjoin": [{ "tabela" : "cadcor", "condicao" : "pa_iten.cor = cadcor.cor" }], "groupBy": ["pa_Iten.cor", "cadcor.descricao"], "where": ["PA_ITEN.CODIGO = '${$(this).attr('data-chave')}'"]}`, 'Pesquisa Cor', 'cadcor', filtraGrade);
    // });


    function rotinaSaidaDeposito() {
        $("#txtDeposito").on("blur", async function () {
            const sDeposito = pegaChave("#txtDeposito");

            $("#txtProduto").autocompleta(
                1,
                `JSON={"tabela": "PRODUTO", "camposSelect": ["PRODUTO.CODIGO CHAVE", "PRODUTO.DESCRICAO", "PRODUTO.CUSTO"], "leftJoin": [{"tabela":"PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO"}], "where": ["PA_ITEN.DEPOSITO = '${sDeposito}' AND PA_ITEN.QUANTIDADE > 0"], "groupBy": ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.CUSTO"]}`,
                ['#txtPrecoSped'],
                ['CUSTO'],
                ['CUSTO'],
                filtraGrade,
                [true]
            );

            $('#btnProduto').pesquisa_serverside(
                ['#txtProduto', '#txtPrecoSped'],
                ['PRODUTO.CODIGO', 'PRODUTO.CUSTO', 'PRODUTO.CODIGO2'],
                ['PRODUTO.DESCRICAO', 'PRODUTO.CUSTO', 'PRODUTO.CODIGO2'],
                `{"tabela": "PRODUTO", "camposSelect": ["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.CODIGO2", "PRODUTO.CUSTO"], "leftJoin": [{"tabela":"PA_ITEN", "condicao": "PA_ITEN.CODIGO = PRODUTO.CODIGO"}], "where": ["PA_ITEN.DEPOSITO = '${sDeposito}' AND PA_ITEN.QUANTIDADE > 0"], "camposWhereServerSide":["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.CODIGO2", "PRODUTO.CUSTO"], "groupBy": ["PRODUTO.CODIGO", "PRODUTO.CODIGO2", "PRODUTO.DESCRICAO", "PRODUTO.CUSTO"]}`,
                'Pesquisa de Produto',
                filtraGrade,
                [false, true]);

            $('#btnLimpaProduto').on('click', function () {
                $('#txtProduto').val('')
            })

            // await carregaDadosProduto();
            rotinaSaidaProduto()
        })
    }

    function rotinaSaidaProduto() {
        $("#txtProduto").on("blur", async function () {
            $("#txtCor").autocompleta(
                1,
                `JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
                    "#txtProduto"
                )}')"]}`,
                [],
                [],
                [],
                filtraGrade
            );

            $("#btnCor").pesquisa_array(
                ["#txtCor"],
                ["CHAVE"],
                ["DESCRICAO"],
                `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "CADCOR", "camposSelect": ["COR CHAVE", "DESCRICAO DESCRICAO"], "where": ["COR IN (SELECT DISTINCT COR FROM [PA_ITEN] WHERE CODIGO='${pegaChave(
                    "#txtProduto"
                )}' AND DEPOSITO='${pegaChave(
                    "#txtDeposito"
                )}' AND QUANTIDADE > 0)"]}`,
                "Pesquisa Cor",
                "cadcor",
                filtraGrade
            )

            $('#btnLimpaCor').on('click', function () {
                $('#txtCor').val('')
            })

            await carregaDadosProduto();
            // rotinaSaidaCor();
        });
    }

    // function rotinaSaidaCor() {
    //     $("#txtCor").on("blur", async function () {
    //         const sCodigo = pegaChave("#txtProduto");
    //         const sCor = pegaChave("#txtCor");
    //         const sDeposito = pegaChave("#txtDeposito");

    //         $("#txtQualidade").autocompleta(
    //             1,
    //             `JSON={"tabela": "PA_ITEN", "camposSelect": ["PA_ITEN.TIPO CHAVE", "TABQUL.DESCRICAO DESCRICAO"], "leftJoin": [{"tabela": "TABQUL", "condicao": "TABQUL.CODIGO = PA_ITEN.TIPO"}], "where": ["PA_ITEN.CODIGO = '${sCodigo}' AND PA_ITEN.COR = '${sCor}' AND PA_ITEN.DEPOSITO = '${sDeposito}' AND PA_ITEN.QUANTIDADE > 0"], "groupBy": ["PA_ITEN.TIPO", "TABQUL.DESCRICAO"]}`,
    //             [],
    //             [],
    //             [],
    //         );

    //         $("#btnQualidade").pesquisa_array(
    //             ["#txtQualidade"],
    //             ["CHAVE"],
    //             ["DESCRICAO"],
    //             `/sisplan/funcoes/v1/pesquisa?JSON={"tabela": "PA_ITEN", "camposSelect": ["PA_ITEN.TIPO CHAVE", "TABQUL.DESCRICAO DESCRICAO"], "leftJoin": [{"tabela": "TABQUL", "condicao": "TABQUL.CODIGO = PA_ITEN.TIPO"}], "where": ["PA_ITEN.CODIGO = '${sCodigo}' AND PA_ITEN.COR = '${sCor}' AND PA_ITEN.DEPOSITO = '${sDeposito}' AND PA_ITEN.QUANTIDADE > 0"], "groupBy": ["PA_ITEN.TIPO", "TABQUL.DESCRICAO"]}`,
    //             "Pesquisa Qualidade",
    //             "PA_ITEN",
    //         )

    //         $('#btnLimpaQualidade').on('click', function () {
    //             $('#txtQualidade').val('')
    //         })

    //         await carregaDadosProduto();
    //     });
    // }

    $('#tabela-movimentados').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        autoWidth: true,
        destroy: true,
        scrollY: "300px",
        "columnDefs": [
            {
                "targets": [5, 6],
                "className": 'pr-4 text-right'
            }
        ]
    });

    $('#tabela-movimentados').on('click', '.btn-excluir', async function () {
        const itemPosicionado = $('#tabela-movimentados').DataTable().row($(this).parents('tr')).data();
        $('#tabela-movimentados').DataTable().row($(this).parents('tr')).remove().draw(false);
        validaEBloqueiaCampos();
        VerificaQuantidadeBipada();
        removeItemListaBarra(itemPosicionado[0], itemPosicionado[2], itemPosicionado[4]);

        const jsonarquivo = montaJsonArquivo();
        await salvaArquivo('JsonSaidaManualProduto', jsonarquivo);
    });

    async function carregaDadosProduto() {
        try {
            let sWhere = '';
            const codigo = pegaChave('#txtProduto');
            // const cor = pegaChave('#txtCor');
            const deposito = pegaChave('#txtDeposito');
            const qualidade = pegaChave('#txtQualidade');

            if (codigo == '') {
                return;
            }

            sWhere = `PRODUTO.CODIGO = '${codigo}' ${deposito != '' ? `AND PA_ITEN.DEPOSITO = '${deposito}'` : ''} `;
            // ${cor != '' ? `AND PA_ITEN.COR = '${cor}'` : '' }
            // ${qualidade != '' ? `AND PA_ITEN.TIPO = '${qualidade}'` : ''}
            const url = `/sisplan/funcoes/v1/pesquisa?`;

            const params = `JSON={"tabela":"PA_ITEN", "camposSelect":[ "PRODUTO.CODIGO", "PA_ITEN.QUANTIDADE QUANTIDADE", "PRODUTO.CUSTO"], "leftjoin": [{ "tabela" : "PRODUTO", "condicao" : "PA_ITEN.CODIGO = PRODUTO.CODIGO " },{ "tabela" : "CADCOR", "condicao" : "PA_ITEN.COR = CADCOR.COR " },{ "tabela" : "TABQUL", "condicao" : "PA_ITEN.TIPO = TABQUL.CODIGO " }],"where": ["${sWhere}"]}`;

            const response = await requisicao('GET', url, params, null);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.mensagem);
                return;
            }

            let quantidade = jsonStr.RESULT[0].reduce((acc, item) => {
                return item.QUANTIDADE > 0 ? acc + item.QUANTIDADE : acc;
            }, 0);

            $('#txtEstoque').val(quantidade);
            // $('#txtPrecoSped').val(jsonStr.RESULT[0][0].CUSTO);

        } catch (error) {
            console.error(error);
        }
    }

    async function documentoEhValido() {
        try {
            const pesquisa = {
                camposSelect: ['CODIGO'],
                tabela: 'PA_MOV',
                where: [`NUM_DOCTO = '${$('#txtDocumento').val()}'`]
            };

            const url = `/sisplan/funcoes/v1/pesquisa?`;
            const params = `JSON=${JSON.stringify(pesquisa)}`;
            const response = await requisicao('GET', url, params, 15000);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                return false;
            }
            return jsonStr.RESULT[0].length > 0;
        } catch (error) {
            return false;
        }
    }

    $('#txtDocumento').on('blur', async function () {
        try {
            $.LoadingOverlay("show");
            let lancto;
            if ($(this).val() == '') {
                let docto = await RetornaDoctoELancto('DOCTO', 'PA_MOV', 'NUM_DOCTO', '6');
                lancto = await RetornaDoctoELancto('LANCTO', 'PA_MOV', 'NUM_DOCTO', '6');
                insereValor('#txtDocumento', docto);
                insereValor('#txtLancamento', lancto);
                $(this).attr('disabled', $(this).val() != '');
            } else {
                if (!await documentoEhValido()) {
                    msgAlerta('Documento inválido, verifique', null, null, () => {
                        $('#txtDocumento').focus();
                    });
                    $('#txtDocumento').val('');
                    return;
                }
                lancto = await RetornaDoctoELancto('LANCTO', 'PA_MOV', 'NUM_DOCTO', '6');
                insereValor('#txtLancamento', lancto);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    $('#btnConfirmar').on('click', async function () {
        if ($('#txtProduto').val() == '') {
            msgErro('Informe um produto para continuar.');
            return;
        }

        if ($('#txtDocumento').val() == '') {
            msgErro('Necessário um número de documento para continuar.');
            return;
        }

        if ($('#txtTipoSaida').val() == '') {
            msgErro('Informe um tipo de saída para continuar.');
            return;
        }

        if ($('#txtQualidade').val() == '') {
            msgErro('Informe uma qualidade para continuar.');
            return;
        }

        if ($('#txtDeposito').val() == '') {
            msgErro('Informe um deposito para continuar.');
            return;
        }

        if ($('#txtCor').val() == '') {
            msgErro('Informe uma cor para continuar.');
            return;
        }

        if ($('#txtPrecoSped').val() <= 0) {
            msgErro('Informe um preço válido para continuar.');
            return;
        }

        // valida grade
        if ($('td>input').length <= 0) {
            msgErro('Não há grade para o produto/cor informado, verifique.');
            return;
        }
        const paramEstoque = await CopiaParametro('VENDA', 4);
        let bTemQtde = false;
        for (let index = 0; index < $('td>input').length; index++) {
            let qtde = $($('td>input')[index]).val();
            if (qtde > 0) {
                bTemQtde = true;
            }
        }
        if (!bTemQtde) {
            msgErro('Grade sem quantidade, impossível continuar.');
            return;
        }

        let sProduto = pegaChave('#txtProduto');
        let sDescricao = pegaDescricao('#txtProduto');
        let sCor = pegaChave('#txtCor');
        let sDescCor = pegaDescricao('#txtCor');
        let sQualidade = pegaChave('#txtQualidade');
        const deposito = pegaChave("#txtDeposito");
        const desc_deposito = pegaDescricao("#txtDeposito");
        let arrEstoque = [];
        // valida estoque
        for (let i = 0; i < $('#tabela-grade').DataTable().rows().count(); i++) {
            const element = $('#tabela-grade').DataTable().row(i).data();
            let sTam = element[0];
            let vQtde = +$($('td>input')[i]).val();
            let vEstoque = element[4];
            const id = element[6];
            const qtdeBipado = retornaQtdeBipada(id);
            if ((paramEstoque == "0") && (vQtde > 0) && (vEstoque < (vQtde + qtdeBipado))) {
                await msgErro(`Quantidade insuficiente para movimentar no tamanho: ${sTam}`);
                return;
            }
        }

        await $('#tabela-grade').DataTable()
            .rows()
            .data()
            .each(async function (value, index) {
                let sTam = value[0];
                let vQtde = $($('td>input')[index]).val();
                let vEstoque = value[4];
                let id = value[6];
                if (vQtde != "" && vQtde > 0) {
                    if ((paramEstoque != "0") || (vEstoque >= vQtde)) {
                        arrEstoque.push(await montaJsonEstoque(sProduto, sCor, sTam, vQtde, $('#txtPrecoSped').val(), $('#txtLote').val(), id, sQualidade, deposito));
                    }
                }

            });

        try {
            await $.LoadingOverlay("show");
            for (let index = 0; index < arrEstoque.length; index++) {
                const element = arrEstoque[index];

                const dados = $('#tabela-movimentados').DataTable().rows().data().toArray();
                const indice = dados.findIndex((item) => item[8] == element.id);

                if (indice == -1) {
                    await $('#tabela-movimentados').DataTable().row.add([
                        sProduto,
                        sDescricao,
                        sCor,
                        sDescCor,
                        element.tamanho,
                        Number(element.quantidade),
                        $('#txtPrecoSped').val(),
                        $('#txtLote').val(),
                        element.id,
                        sQualidade,
                        deposito,
                        desc_deposito,
                        retornaBotaoOpcoes()
                    ]).draw(false);
                } else {
                    let data_old = $('#tabela-movimentados').DataTable().row(indice).data();
                    data_old[5] += Number(element.quantidade);
                    $('#tabela-movimentados').DataTable().row(indice).data(data_old).draw(false);
                }
            }
            VerificaQuantidadeBipada();
        } finally {
            $.LoadingOverlay("hide");
            $('#modal-grade').modal('hide');
        }

        const jsonarquivo = montaJsonArquivo();
        await salvaArquivo('JsonSaidaManualProduto', jsonarquivo);
    });

    $('#btnMenosOuMais').on('click', function () {
        const estaComoEstorno = $('#btnMenosOuMais>i.fa-minus').length > 0;
        $('#labelBarras').html(estaComoEstorno ? 'Barra' : 'Barra Estorno');
        $('#txtBarra').attr('placeholder', estaComoEstorno ? 'Barra' : 'Barra Estorno');
        $('#txtBarra').focus();
        $('#btnMenosOuMais').attr('data-estorno', !estaComoEstorno);
        if (estaComoEstorno) {
            $('#btnMenosOuMais>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');
        } else { $('#btnMenosOuMais>i.fa-plus').removeClass('fa-plus').addClass('fa-minus'); }
    });
    async function retornaQuantidadeGrid() {
        try {

            listaBarrasBipadas.find(item => item.barra == sBarra);

        } catch (e) {
            console.error(e);
        }
    }

    $('#txtBarra').on('blur', async function () {
        let qtde = +$('#txtQuantidade').val();
        const estornaQuantidade = $('#btnMenosOuMais').attr('data-estorno');
        const ehPrimeiroRegistro = $('#tabela-movimentados').DataTable().rows().data().toArray().length === 0;
        const ehbarralog = await retornaBarraLogLida($('#txtBarra').val()) == "barra_log";

        if ($('#txtBarra').val() == '') {
            return;
        }

        if (!ehbarralog && bApenasBarraLog) {
            msgAlerta('Barra log não encontrada, impossível continuar!');
            return;
        }

        if (ehPrimeiroRegistro && estornaQuantidade == 'true') {
            SomAlerta(BASE_URI, true);
            return msgAlerta("Nenhuma barra encontrada para estornar!");
        }

        try {
            $.LoadingOverlay("show");
            bloqueiaCampos('card-body', true);

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();
            if (erros != 0) {
                $('#txtBarra').val('');
                $('#txtBarra').focus();
                return;
            }

            if (!($('#txtQuantidade').val() > 0)) {
                msgAlerta('Quantidade inválida, favor verificar!');
                SomAlerta(BASE_URI, true);
                return;
            }
            if ($('#txtLote').val() == '') {
                msgAlerta('Lote inválido, favor verificar!');
                SomAlerta(BASE_URI, true);
                return;
            }

            let dadosBarra = await retornaDadosBarra($(this).val(), ehbarralog);

            let dadosProd = dadosBarra.length == 0 ? null : dadosBarra[0];
            if (dadosProd == null) {
                SomAlerta(BASE_URI, true);
                msgAlerta('Nenhum dado para esta barra!');
                $('#txtBarra').val('');
                $('#txtBarra').focus();
                return;
            }

            if (utilizaBarraLog && ehbarralog && $("#txtQuantidade").val() > 1) {
                SomAlerta(BASE_URI, true);
                msgAlerta("Quantidade inválida. Permitido bipar somente uma quantidade na barra log.");
                return;
            }

            const barraEstornada = utilizaBarraLog ? await barraJaEstornada($('#txtBarra').val()) : false;

            if (barraEstornada && estornaQuantidade == 'true' && ehbarralog) {
                SomAlerta(BASE_URI, true);
                msgErro(`Barra ${$('#txtBarra').val()} já estornada, verifique.`);
                return;
            }

            if (utilizaBarraLog) {
                if (estornaQuantidade == 'true') {
                    await estornaBarraBipada($('#txtBarra').val());
                }
            }

            const barraBipada = utilizaBarraLog ? await barraJaEstaBipada($('#txtBarra').val()) : false;
            if (utilizaBarraLog) {
                if (estornaQuantidade == 'false') {
                    await adicionaBarraBipada(
                        {
                            codigo: dadosProd.CODIGO,
                            cor: dadosProd.COR,
                            tam: dadosProd.TAM,
                            barra: $('#txtBarra').val(),
                        }
                    );
                }
            }

            let existeRegistroEstorno = false;

            if (!barraBipada) {

                //     $('#tabela-movimentados').DataTable().rows().data().map((item, index) => {
                //         if ((dadosProd.CODIGO == item[0]) && (dadosProd.COR == item[2]) && (dadosProd.TAM == item[3]) && ($('#txtLote').val() == item[6])) {
                //             if (estornaQuantidade == 'false') {
                //                 qtde = parseFloat(item[4]) + parseFloat($('#txtQuantidade').val());
                //             } else {
                //                 qtde = parseFloat(item[4]) - parseFloat($('#txtQuantidade').val());
                //             }

                //             $('#txtQuantidade').val(qtde);
                //             $('#tabela-movimentados').DataTable().rows(index).remove().draw();
                //         }
                //         return 'ok';
                //     });
                //     const paramEstoque = await CopiaParametro('VENDA', 4) == 0;

                $('#tabela-movimentados').DataTable().rows().data().map((item, index) => {
                    if ((dadosProd.CODIGO == item[0]) && (dadosProd.COR == item[2]) && (dadosProd.TAM == item[4]) && ($('#txtLote').val() == item[7]) && (dadosProd.TIPO == item[9])) {
                        if (estornaQuantidade == 'false') {
                            qtde = parseFloat(item[5]);
                        } else {
                            qtde = parseFloat(item[5]) - parseFloat($('#txtQuantidade').val());
                            $('#txtQuantidade').val(qtde);
                        }

                        existeRegistroEstorno = true;
                        $('#tabela-movimentados').DataTable().rows(index).remove().draw();
                    }
                    return 'ok';
                });

                const paramEstoque = await CopiaParametro('VENDA', 4);

                let qtdeTotal = 0;

                if (estornaQuantidade == 'false') {
                    if (!existeRegistroEstorno) {
                        qtdeTotal = parseFloat($('#txtQuantidade').val());
                    } else {
                        qtdeTotal = parseFloat($('#txtQuantidade').val()) + qtde;
                    }
                }

                //     if (paramEstoque) {
                //         if (dadosProd.QUANTIDADE < qtde) {
                //             msgAlerta('Quantidade insuficiente no estoque para essa barra!');
                //             if (estornaQuantidade == 'false') {
                //                 qtde = dadosProd.QUANTIDADE;
                //                 $('#txtQuantidade').val(dadosProd.QUANTIDADE);
                //             }
                //         }
                //     }

                if (paramEstoque != "2") {

                    if (estornaQuantidade == 'false') {
                        if (dadosProd.QUANTIDADE < qtdeTotal) {
                            msgAlerta('Quantidade insuficiente no estoque para essa barra!');
                            if (paramEstoque == "1") {
                                qtde = qtdeTotal;
                            } else if (!existeRegistroEstorno) {
                                qtde = 0;
                                if (utilizaBarraLog) {
                                    estornaBarraBipada($('#txtBarra').val());
                                }
                            }
                        } else {
                            if (existeRegistroEstorno) {
                                qtde = qtdeTotal;
                            }
                        }
                    } else {
                        if (!existeRegistroEstorno) {
                            msgAlerta('Barra não foi bipada para realizar o estorno!');
                            qtde = 0;
                        }
                    }
                } else {
                    if (estornaQuantidade == 'false') {
                        qtde = qtdeTotal;
                    }
                }

                //     if (ehPrimeiroRegistro || qtde > 0) {
                if (qtde > 0) {
                    $('#tabela-movimentados').DataTable().row.add([
                        dadosProd.CODIGO,
                        dadosProd.DESCRICAO,
                        dadosProd.COR,
                        dadosProd.DESCCOR,
                        dadosProd.TAM,
                        qtde,
                        dadosProd.CUSTO,
                        $('#txtLote').val(),
                        dadosProd.ID,
                        dadosProd.TIPO,
                        pegaChave("#txtDeposito"),
                        pegaDescricao("#txtDeposito"),
                        retornaBotaoOpcoes()
                    ]).draw(false);
                    SomAlerta();
                    VerificaQuantidadeBipada();
                }
            }

            $('#tabela-movimentados tbody tr:last-child').trigger('click');
            let $scrollBody = $($('#tabela-movimentados').DataTable().table().node()).parent();
            $scrollBody.scrollTop($scrollBody.get(0).scrollHeight);

            validaEBloqueiaCampos();
            await VerificaQuantidadeBipada();

            const jsonarquivo = montaJsonArquivo();
            await salvaArquivo('JsonSaidaManualProduto', jsonarquivo);

        } finally {
            bloqueiaCampos('card-body', false);
            $.LoadingOverlay("hide");
            $('#txtBarra').val('');
            $('#txtQuantidade').val('1');
            $('#txtBarra').focus();
        }

    });

    $("#btnCancelarSaidaManual").on("click", async function () {
        msgAlerta("Deseja realmente cancelar a movimentação?", () => { deletaArquivo('JsonSaidaManualProduto'), window.location.reload(); });

    });

    $('#tabela-movimentados tbody').on('click', 'tr', function () {
        const tabelamovimentados = $('#tabela-movimentados').DataTable();
        tabelamovimentados.$('tr.selected').removeClass('selected');
        $(this).addClass('selected');
    });

    $('#confirmar_mov').on('click', async function () {
        try {
            $('#confirmar_mov').prop('disabled', true);
            $.LoadingOverlay("show");
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros != 0) {
                $('#confirmar_mov').prop('disabled', false);
                return;
            }

            if ($('#tabela-movimentados').DataTable().rows().count() == 0) {
                $('#confirmar_mov').prop('disabled', false);
                msgAlerta('Nenhum produto bipado, favor verificar.');
                return;
            }
            await gravarMovimentacao();
        } catch (error) {
            console.error(error);
            $('#confirmar_mov').prop('disabled', false);
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    async function VerificaQuantidadeBipada() {
        const quantidade = $("#tabela-movimentados")
            .DataTable()
            .column(5, {})
            .data()
            .sum();
        $('#txtQuantidadeBipada').val(+quantidade);
    }

    $('#msform').validate({
        ignore: "",
        rules: {
            txtDocumento: {
                required: true,
            },
            txtTipoSaida: {
                required: true,
            },
            txtQualidade: {
                required: true,
            },
            txtDeposito: {
                required: true,
            },
            txtDataMovimentoSaida: {
                required: true,
            },
            txtFuncionario: {
                required: true,
            }
        },
        messages: {
            txtDocumento: {
                required: "Gere um documento para continuar."
            },
            txtTipoSaida: {
                required: "Informe um tipo de entrada."
            },
            txtQualidade: {
                required: "Informe uma qualidade."
            },
            txtDeposito: {
                required: "Informe um depósito."
            },
            txtDataMovimentoSaida: {
                required: "Informe uma data de movimento."
            },
            txtFuncionario: {
                required: "Informe um funcionário."
            }
        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element) {
            $(element).removeClass('is-invalid');
        }
    });

    function validaEBloqueiaCampos() {
        let bTabela = $('#tabela-movimentados').DataTable().rows().count() > 0;
        $('#txtDocumento').prop('disabled', bTabela);
        $('#txtTipoSaida').prop('disabled', bTabela);
        $('#txtQualidade').prop('disabled', bTabela);
        $('#txtDeposito').prop('disabled', bTabela);
        $('#btnTipoSaida').prop('disabled', bTabela);
        $('#btnLimpaTipoSaida').prop('disabled', bTabela);
        $('#btnQualidade').prop('disabled', bTabela);
        $('#btnLimpaQualidade').prop('disabled', bTabela);
        $('#btnDeposito').prop('disabled', bTabela);
        $('#btnLimpaDeposito').prop('disabled', bTabela);
    }

    $('.somAtivo').on('click', function () {
        $(this).addClass('d-none');
        localStorage.setItem("@prodSaida.somAtivo", false);
        $('.somInativo').removeClass('d-none');
    });

    $('.somInativo').on('click', function () {
        $(this).addClass('d-none');
        localStorage.setItem("@prodSaida.somAtivo", true);
        $('.somAtivo').removeClass('d-none');
    });

    const somAtivo = localStorage.getItem('@prodSaida.somAtivo') ?? 'false';
    if (somAtivo == 'true') {
        $($('.somInativo')[0]).trigger('click');
    }

    function montaJsonEstoque(codigo, cor, tam, qtde, custo, lote, id, qualidade, deposito) {
        let EstProd = {
            codigo,
            cor,
            tamanho: tam,
            deposito: deposito,
            quantidade: qtde,
            documento: $('#txtDocumento').val(),
            custo,
            qualidade: qualidade,
            lote,
            unidade: '',
            descricao: '',
            tipobaixa: pegaChave('#txtTipoSaida'),
            tipo: 'MN',
            observacao: $('#txtObs').val(),
            id: id,
            funcionario: pegaChave('#txtFuncionario'),
            cliente: pegaChave('#txtCliente'),
            data: $('#txtDataMovimentoSaida').val()
        };
        return EstProd;
    }

    async function gravarMovimentacao() {
        try {
            if (($('#txtDocumento').val() != '') && (await documentoEhValido())) {
                msgAlerta('Este número de documento já existe uma saída, deseja continuar?', async () => { await gravar() }, () => { $('#confirmar_mov').prop('disabled', false); });
            } else {
                await gravar();
            }

            async function gravar() {
                const listaEstProd = {
                    produtos: []
                };
                $('#tabela-movimentados').DataTable().rows().data().each(async function (value) {
                    listaEstProd.produtos.push(montaJsonEstoque(value[0], value[2], value[4], value[5], value[6], value[7], value[8], value[9], value[10]));
                });
                let sLancto = $('#txtLancamento').val();

                const barraslog = {
                    barras: utilizaBarraLog ? listaBarrasBipadas : []
                };

                let response = await requisicao(pagar = 'POST', '/Sisplan/Estoque/V1/MovimentaEstoque?', '', `JSON=${encodeURIComponent(JSON.stringify(listaEstProd))}&LANCTO=${sLancto}&TIPO=SAIDA&JSONBARRAS=${encodeURIComponent(JSON.stringify(barraslog))}`, 300000);

                if (!response) {
                    $('#confirmar_mov').prop('disabled', false);
                    return;
                }

                if (response.status != 200) {
                    const jsonStr = await response.json();
                    $('#confirmar_mov').prop('disabled', false);
                    msgErro(jsonStr.mensagem);
                    return;
                }

                msgAlerta('Deseja imprimir a movimentação?',
                    () => { },
                    () => { callBack(); },
                    async () => {
                        await ImprimirRelatorio();
                        callBack();
                    },
                    () => { callBack(); });

                function callBack() {

                    toastr.success("Movimentação realizada com sucesso!", "Confirmação", {
                        toastClass: "alert",
                        iconClasses: {
                            error: "alert-error",
                            info: "alert-info",
                            success: "alert-success",
                            warning: "alert-warning",
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.reload();
                        },
                    }).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px",
                    });

                }

                await deletaArquivo('JsonSaidaManualProduto');
            }
        } catch (error) {
            console.error(error);
            $('#confirmar_mov').prop('disabled', false);
            msgErro(`Não foi possível gravar os dados do Estoque: ${error}`);
        }
    }

    async function adicionaBarraBipada(objItem) {
        try {
            const retornoBarraLog = await retornaBarraLogLida(objItem.barra);
            if (['barra_log'].includes(retornoBarraLog)) {
                listaBarrasBipadas.push(objItem);
                return true;
            }
            return false;

        } catch (error) {
            console.error(error);
        }
    }

    async function retornaDadosBarra(sBarra, bBarraLog) {
        let barra28 = sBarra;
        if (bBarraLog) {
            barra28 = await extraiBarra28(sBarra);
        }
        const deposito = pegaChave('#txtDeposito');
        const qualidade = pegaChave('#txtQualidade');

        if (deposito == '') {
            msgAlerta('Depósito não informado, impossível continuar!');
            SomAlerta(BASE_URI, true);
            return;
        }

        if (qualidade == '') {
            msgAlerta('Qualidade não informada, impossível continuar!');
            SomAlerta(BASE_URI, true);
            return;
        }

        let url = `/sisplan/funcoes/v1/pesquisa?`;
        let params = encodeURIComponent(`JSON={"tabela":"PA_ITEN", "camposSelect":["PA_ITEN.CODIGO", "PRODUTO.DESCRICAO", "PA_ITEN.COR", "CADCOR.DESCRICAO DESCCOR", "PA_ITEN.TAM", "PRODUTO.CUSTO", "PA_ITEN.QUANTIDADE", "PA_ITEN.ID", "PA_ITEN.TIPO"],
        "innerjoin": [{ "tabela" : "PRODUTO", "condicao" : "PA_ITEN.CODIGO = PRODUTO.CODIGO" }],
        "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "CADCOR.COR = PA_ITEN.COR"}],
        "where": ["PA_ITEN.TIPO = '${qualidade}' AND PA_ITEN.DEPOSITO = '${deposito}' AND (PA_ITEN.BARRA = '${sBarra}' OR PA_ITEN.BARRA28 = '${sBarra}' OR PA_ITEN.BARRA28 = '${barra28}' OR PA_ITEN.BARRACLI = '${sBarra}')"]}`);

        try {
            let response = await requisicao('GET', url, params, null);
            if (!response) {
                return '';
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                SomAlerta(BASE_URI, true);
                return '';
            }

            return jsonStr.RESULT[0];

        } catch (error) {
            console.error(error);
            SomAlerta(BASE_URI, true);
            msgErro('Não foi possível buscar os dados da barra.');
            return '';
        }
    }

    async function retornaBarraLogLida(sBarra) {
        try {
            const url = `/sisplan/barralog/v1/validarbarra?`;
            const params = `barra=${encodeURIComponent(sBarra)}`;
            const response = await requisicao('GET', url, params, 15000);

            if (!response) {
                return;
            }

            jsonStr = await response.json();
            if (response.status != 200) {
                return jsonStr.mensagem;
            }

            return jsonStr.mensagem;
        } catch (error) {
            console.error(error);
        }
    }

    async function barraJaEstaBipada(sBarra) {
        try {
            if (listaBarrasBipadas.find(item => item.barra == sBarra)) {
                msgErro(`Barra ${sBarra} já lida, verifique.`);
                return true;
            }
            return false;
        } catch (error) {
            console.error('barra_log', error);
            msgErro('Erro ao processar barra log.');
            return false;
        }
    }

    async function barraJaEstornada(sBarra) {
        try {
            if (listaBarrasBipadas.find(item => item.barra == sBarra)) {
                return false;
            }
            return true;
        } catch (error) {
            console.error('barra_log', error);
            msgErro('Erro ao processar barra log.');
            return false;
        }
    }

    async function removeItemListaBarra(sCodigo, sCor, sTam) {
        try {
            listaBarrasBipadas = [...listaBarrasBipadas.filter(item => item.codigo !== sCodigo && item.cor !== sCor && item.tam !== sTam)];
        } catch (error) {
            console.error(error);
        }
    }

    async function estornaBarraBipada(sBarra) {
        try {
            listaBarrasBipadas = [...listaBarrasBipadas.filter(item => item.barra !== sBarra)];
        } catch (error) {
            console.error(error);
        }
    }

    function retornaBotaoOpcoes() {
        return '<div class="divBtnOpcoes"> ' +
            '    <button class="botaoOpcoes btn-excluir" type="button"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
            '   </div>';
    }

    retornaHintRelatorio('btnImprimir', 'relsaidabarraproduto')

    $("#btnImprimir").on("click", async function () {
        ImprimirRelatorio();
    });

    async function ImprimirRelatorio() {
        let dadosBackEnd = {};
        let arrayTransferencia = [];
        const Dados = $('#tabela-movimentados').DataTable().rows().data();
        const documento = $('#txtDocumento').val();
        Dados.each((campo => {
            dadosBackEnd = {
                CODIGO: campo[0],
                DESCRICAO: campo[1],
                COR: campo[2],
                DESC_COR: campo[3],
                TAM: campo[4],
                QTDE: campo[5],
                PRECOSPED: campo[6],
                LOTE: campo[7],
                NUM_DOCTO: documento,
                DT_MVTO: obterDataFormatada(),
                QUALIDADE: campo[9],                
                DEPOSITO: campo[10],
                DESC_DEPOSITO: campo[11]                                
            };
            arrayTransferencia.push(dadosBackEnd);
        }));
        const url = `/sisplan/impressao/v1/imprimirsaidaporbarra?`;
        const params = `JSON=${JSON.stringify(arrayTransferencia)}&DOCUMENTO=${documento}&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const response = await requisicao('POST', url, '', params, 360000);
        const arquivo = await response.text();

        if (arquivo != undefined) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
            await limparRelatorios();
        }
    };

    function limpaCampos() {
        // limpaValor('#txtPrecoSped');
        // limpaValor('#txtProduto');
        limpaValor('#txtCor');
        limpaValor('#txtQuantidade');
        limpaValor('#txtBarra');
        limpaValor('#txtObs');
        $('#tabela-grade').DataTable().rows().remove().draw(false);
    }

    try {
        const response = await carregaArquivo('JsonSaidaManualProduto');
        if (response.status === 200) {
            const jsonStr = await response.json();
            insereValor("#txtDocumento", jsonStr.documento);
            insereValor("#txtLancamento", jsonStr.lancamento);
            insereValor("#txtDataMovimentoSaida", jsonStr.data);
            insereValor("#txtTipoSaida", jsonStr.tiposaida.split("] - ")[0].substr(1), jsonStr.tiposaida.split("] - ")[1]);
            insereValor("#txtQualidade", jsonStr.qualidade.split("] - ")[0].substr(1), jsonStr.qualidade.split("] - ")[1]);
            insereValor("#txtDeposito", jsonStr.deposito.split("] - ")[0].substr(1), jsonStr.deposito.split("] - ")[1]);
            insereValor("#txtFuncionario", jsonStr.funcionario.split("] - ")[0].substr(1), jsonStr.funcionario.split("] - ")[1]);
            insereValor("#txtCliente", jsonStr.cliente.split("] - ")[0].substr(1), jsonStr.cliente.split("] - ")[1]);
            jsonStr.itens.forEach((item) => {
                $("#tabela-movimentados")
                    .DataTable()
                    .row.add([
                        item.codigo,
                        item.descricao,
                        item.cor,
                        item.desc_cor,
                        item.tam,
                        item.qtde,
                        item.precosped,
                        item.lote,
                        item.id,
                        item.tipo,
                        item.deposito,
                        item.desc_deposito,
                        retornaBotaoOpcoes(),
                    ])
                    .draw(false);
            });
            listaBarrasBipadas = jsonStr.barrasbipadas;
            VerificaQuantidadeBipada();
            msgAlerta("Carregado dados não salvos, verifique.");
        }
    } catch (error) {
        console.log(error);
    }

    function obterDataFormatada() {
        const data = new Date();
        const dia = String(data.getDate()).padStart(2, '0');
        const mes = String(data.getMonth() + 1).padStart(2, '0');
        const ano = data.getFullYear();

        const dataFormatada = `${ano}-${mes}-${dia}`;
        return dataFormatada;
    }

    function montaJsonItens() {
        const itensDataTable = $("#tabela-movimentados").DataTable().data().toArray();
        const itens = itensDataTable.map((itemDT) => {
            const item = {
                codigo: itemDT[0],
                descricao: itemDT[1],
                cor: itemDT[2],
                desc_cor: itemDT[3],
                tam: itemDT[4],
                qtde: itemDT[5],
                precosped: itemDT[6],
                lote: itemDT[7],
                id: itemDT[8],
                tipo: itemDT[9],
                deposito: itemDT[10],
                desc_deposito: itemDT[11]
            };
            return item;
        });
        return itens;
    }

    function montaJsonArquivo() {
        const importacao = {
            documento: $("#txtDocumento").val(),
            lancamento: $("#txtLancamento").val(),
            tiposaida: $("#txtTipoSaida").val(),
            qualidade: $("#txtQualidade").val(),
            deposito: $("#txtDeposito").val(),
            funcionario: $("#txtFuncionario").val(),
            data: $("#txtDataMovimentoSaida").val(),
            itens: montaJsonItens(),
            cliente: $('#txtCliente').val(),
            barrasbipadas: listaBarrasBipadas,
        };
        return importacao;
    }

    async function buscaValoresPadroesTela() {
        $.LoadingOverlay('show');
        try {

            const classValores = { POSICAO: '9' };
            const response = await requisicao('POST', '/sisplan/valorespadroes/v1/buscar?', '', JSON.stringify(classValores), null);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();

            insereValor('#txtTipoSaida', jsonStr.tipoSaida);
            insereValor('#txtQualidade', jsonStr.qualidade);
            insereValor('#txtDeposito', jsonStr.deposito);

            const buscarCores = async () => {
                const dados = await buscaValoresPadroes('PRODUTO')
                dados.forEach(item => {
                    if (item.CAMPO === 'COR_SAI_MANUAL' && item.VALOR) {
                        insereValor('#txtCor', item.VALOR, { tabela: 'CADCOR', campoBusca: 'DESCRICAO', campoWhere: 'COR', valorWhere: item.VALOR });
                    }
                });
            };

            const buscarTipos = async () => {
                const dados = await buscaValoresPadroes('ESTOQUE')
                dados.forEach(item => {
                    if (item.CAMPO === 'SAIDA_PROD' && item.VALOR) {
                        insereValor('#txtTipoSaida', item.VALOR, {
                            tabela: 'TABBAI',
                            campoBusca: 'DESCRICAO',
                            campoWhere: 'CODIGO',
                            valorWhere: item.VALOR
                        });
                    }
                });
            };

            await Promise.all([buscarCores(), buscarTipos()]);

        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    function retornaQtdeBipada(id) {
        const tabelaMovimentados = $('#tabela-movimentados').DataTable();
        let qtdeTotal = 0;

        tabelaMovimentados.rows().every(function () {
            const dadosLinha = this.data();

            if (dadosLinha[8] == id) {
                qtdeTotal += parseInt(dadosLinha[5]);
            }
        });

        return qtdeTotal;
    }

    await preencheOrdenacaoTela('SaidaBarraProduto');

});
