$(document).ready(async function () {
  $('#modalItensNaoEfetivados').on('hide.bs.modal', () => {
    criaMensagemSucesso(`Solicitação ${pegaValor('#txtNumero')} gravada com sucesso!`, () => { window.location.href = `${BASE_URI}/solicitacao_compra`; });
    ModalItensNaoEfetivados.limparModal()
  })
})

window.ModalItensNaoEfetivados = window.ModalItensNaoEfetivados || {}

ModalItensNaoEfetivados.carregarModal = ({ itens }) => {
  itens.forEach(
    (item) => {
      let htmlCardItem = ''
      switch (item.tipo) {
        case 'Material':
          htmlCardItem = `
            <div class="containerItemNaoEfetivado text-normal">
              <div class="flex" style="gap: 12px; max-width: 100%">
                <div class="flex" style="gap: 3px; overflow-x: hidden">
                  <span class="font-weight-bold">Item:</span>
                  <span style="-webkit-box-orient: vertical; -webkit-line-clamp: 1; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">${item.codigo} - ${item.descricao}</span>
                </div>
              </div>
              <div class="flex" style="gap: 12px; max-width: 100%">
                <div class="flex" style="gap: 3px">
                  <span class="font-weight-bold">Tipo:</span>
                  <span>${item.tipo}</span>
                </div>
                <div class="flex" style="gap: 3px; overflow-x: hidden">
                  <span class="font-weight-bold">Cor:</span>
                  <span style="-webkit-box-orient: vertical; -webkit-line-clamp: 1; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">${item.cor} - ${item.descricaoCor}</span>
                </div>
              </div>
              <div class="flex" style="gap: 12px; max-width: 100%">
                <div class="flex" style="gap: 3px">
                  <span class="font-weight-bold">Quantidade:</span>
                  <span>${parseFloat(item.quantidade).toFixed(2)}</span>
                </div>
                <div class="flex" style="gap: 3px">
                  <span class="font-weight-bold">Preço:</span>
                  <span>${parseFloat(item.preco).toFixed(2)}</span>
                </div>
                <div class="flex" style="gap: 3px; overflow-x: hidden">
                  <span class="font-weight-bold">Valor:</span>
                  <span style="-webkit-box-orient: vertical; -webkit-line-clamp: 1; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">${parseFloat(item.valor).toFixed(2)}</span>
                </div>
              </div>
            </div>
          `
          break
        case 'Produto':
          htmlCardItem = `
            <div class="containerItemNaoEfetivado text-normal">
              <div class="flex" style="gap: 12px; max-width: 100%">
                <div class="flex" style="gap: 3px; overflow-x: hidden">
                  <span class="font-weight-bold">Item:</span>
                  <span style="-webkit-box-orient: vertical; -webkit-line-clamp: 1; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">${item.codigo} - ${item.descricao}</span>
                </div>
              </div>
              <div class="flex" style="gap: 12px; max-width: 100%">
                <div class="flex" style="gap: 3px">
                  <span class="font-weight-bold">Tipo:</span>
                  <span>${item.tipo}</span>
                </div>
                <div class="flex" style="gap: 3px">
                  <span class="font-weight-bold">Tamanho:</span>
                  <span>${item.tamanho}</span>
                </div>
                <div class="flex" style="gap: 3px; overflow-x: hidden">
                  <span class="font-weight-bold">Cor:</span>
                  <span style="-webkit-box-orient: vertical; -webkit-line-clamp: 1; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">${item.cor} - ${item.descricaoCor}</span>
                </div>
              </div>
              <div class="flex" style="gap: 12px; max-width: 100%">
                <div class="flex" style="gap: 3px">
                  <span class="font-weight-bold">Quantidade:</span>
                  <span>${parseFloat(item.quantidade).toFixed(2)}</span>
                </div>
                <div class="flex" style="gap: 3px">
                  <span class="font-weight-bold">Preço:</span>
                  <span>${parseFloat(item.preco).toFixed(2)}</span>
                </div>
                <div class="flex" style="gap: 3px; overflow-x: hidden">
                  <span class="font-weight-bold">Valor:</span>
                  <span style="-webkit-box-orient: vertical; -webkit-line-clamp: 1; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">${parseFloat(item.valor).toFixed(2)}</span>
                </div>
              </div>
            </div>
          `
          break
        case 'Serviço':
          htmlCardItem = `
            <div class="containerItemNaoEfetivado text-normal">
              <div class="flex" style="gap: 12px; max-width: 100%">
                <div class="flex" style="gap: 3px; overflow-x: hidden">
                  <span class="font-weight-bold">Item:</span>
                  <span style="-webkit-box-orient: vertical; -webkit-line-clamp: 1; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">${item.codigo} - ${item.descricao}</span>
                </div>
              </div>
              <div class="flex" style="gap: 12px; max-width: 100%">
                <div class="flex" style="gap: 3px">
                  <span class="font-weight-bold">Tipo:</span>
                  <span>${item.tipo}</span>
                </div>
              </div>
              <div class="flex" style="gap: 12px; max-width: 100%">
                <div class="flex" style="gap: 3px">
                  <span class="font-weight-bold">Quantidade:</span>
                  <span>${parseFloat(item.quantidade).toFixed(2)}</span>
                </div>
                <div class="flex" style="gap: 3px">
                  <span class="font-weight-bold">Preço:</span>
                  <span>${parseFloat(item.preco).toFixed(2)}</span>
                </div>
                <div class="flex" style="gap: 3px; overflow-x: hidden">
                  <span class="font-weight-bold">Valor:</span>
                  <span style="-webkit-box-orient: vertical; -webkit-line-clamp: 1; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">${parseFloat(item.valor).toFixed(2)}</span>
                </div>
              </div>
            </div>
          `
          break
      }
      $('#containerItensNaoEfetivados').append(htmlCardItem)
    }
  )

  $('#modalItensNaoEfetivados').modal('show')
}

ModalItensNaoEfetivados.limparModal = () => $('#containerItensNaoEfetivados').empty()